/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.bpa;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.bpm.collections.Tuple;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;

public class AnnotationsTableModel
extends AbstractTableModel {
    private final List<Tuple<String, String>> annotations;
    private final Msg[] columns = new Msg[]{DesignerMsg.NAME, DesignerMsg.VALUE};

    public AnnotationsTableModel(@NotNull FlowNode flowNode) {
        this.annotations = this.mapToList(flowNode.getAnnotations(true));
    }

    public String getColumnName(int column) {
        return this.columns[column].getString();
    }

    public int getColumnCount() {
        return this.columns.length;
    }

    public int getRowCount() {
        return this.annotations.size();
    }

    public Object getValueAt(int row, int column) {
        Tuple<String, String> tuple = this.annotations.get(row);
        return column == 0 ? tuple.getFirst() : tuple.getSecond();
    }

    private List<Tuple<String, String>> mapToList(@NotNull Map<String, String> map) {
        List<Tuple<String, String>> annotations;
        if (!map.isEmpty()) {
            annotations = new ArrayList<Tuple<String, String>>(map.size());
            for (Map.Entry<String, String> annotation : map.entrySet()) {
                annotations.add(Tuple.create(annotation.getKey(), annotation.getValue()));
            }
        } else {
            annotations = Collections.emptyList();
        }
        return annotations;
    }
}

