/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.argumentsdefinition;

import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.argumentsdefinition.ArgumentsTableModel;
import oracle.bpm.designer.datadeclaration.DataDeclarationDialog;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.Color;
import oracle.bpm.project.model.catalog.AccessType;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ColorProvider;
import oracle.bpm.ui.TableColorProvider;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.table.BaseTablePanel;
import oracle.bpm.ui.table.TableModel;
import org.jetbrains.annotations.NotNull;

public class ArgumentsTable
extends BaseTablePanel {
    private AccessType accessType;
    private DataDeclarationContainer argumentsContainer;
    private boolean arraysSupported;

    private ArgumentsTable(@NotNull UiContainer parent, @NotNull DataDeclarationContainer argumentsContainer, @NotNull AccessType accessType, @NotNull ArgumentsTableModel model, boolean arraysSupported) {
        super(parent, Msg.QUOTE(""), DesignerMsg.ARGUMENTS_DEFINITION, (TableModel)model, BaseTablePanel.Style.TOOLBAR_TOP);
        this.argumentsContainer = argumentsContainer;
        this.accessType = accessType;
        this.arraysSupported = arraysSupported;
        this.setWithColons(true);
        this.init();
    }

    public static ArgumentsTable create(@NotNull UiContainer parent, @NotNull DataDeclarationContainer argumentsContainer, @NotNull AccessType accessType, boolean arraysSupported) {
        ArgumentsTableModel model = new ArgumentsTableModel();
        return new ArgumentsTable(parent, argumentsContainer, accessType, model, arraysSupported);
    }

    public DataDeclarationContainer getArgumentsContainer() {
        return this.argumentsContainer;
    }

    protected boolean showEditAction() {
        return true;
    }

    protected void addAction() {
        try {
            Sequence<DataDeclaration> usedArguments = CollectionUtils.asSequence(this.getArgumentsTableModel().getData());
            String name = DataDeclarationDialog.getDefaultDeclarationName(usedArguments, "argument");
            CatalogType type = DataDeclarationDialog.getDefaultType();
            DataDeclaration argument = this.argumentsContainer.createDeclaration(name, type, this.accessType);
            DataDeclarationDialog dialog = DataDeclarationDialog.createForArgument(this.getOwnerWindow(), argument, usedArguments, this.arraysSupported, true);
            dialog.setVisible(true);
            if (dialog.userAccepted()) {
                this.argumentsContainer.addDeclaration(argument);
                this.getArgumentsTableModel().addRow(argument);
            }
        }
        catch (ProjectException e) {
            throw new RuntimeException(e);
        }
    }

    protected void deleteAction() {
        try {
            int[] selectedRows;
            for (int selectedRow : selectedRows = this.getTable().getSelectedRows()) {
                DataDeclaration argument = (DataDeclaration)this.getArgumentsTableModel().getRow(selectedRow);
                this.argumentsContainer.removeDeclaration(argument);
            }
        }
        catch (ProjectException e) {
            throw new RuntimeException(e);
        }
        super.deleteAction();
    }

    protected void enableEditActions(boolean enabled) {
        this.getEditAction().setEnabled(enabled && this.getTable().getSelectedRowCount() == 1);
    }

    protected void editAction() {
        DataDeclaration dataDeclaration = (DataDeclaration)this.getArgumentsTableModel().getRow(this.getTable().getSelectedRow());
        Sequence<DataDeclaration> usedArguments = CollectionUtils.asSequence(this.getArgumentsTableModel().getData());
        DataDeclarationDialog dialog = DataDeclarationDialog.createForArgument(Ui.getRoot(), dataDeclaration, usedArguments, this.arraysSupported, false);
        dialog.setVisible(true);
        if (dialog.userAccepted()) {
            this.getArgumentsTableModel().fireTableDataChanged();
        }
    }

    private void init() {
        this.getTable().getColumn(1).setColorProvider((ColorProvider)new TableColorProvider.Default(){

            public Color getForeground(Object element) {
                DataDeclaration argument = (DataDeclaration)ArgumentsTable.this.getArgumentsTableModel().getRow(this.getRow());
                return argument.getType().isUnknown() ? Color.RED : null;
            }
        });
        for (DataDeclaration argument : this.argumentsContainer.getLocalDeclarations()) {
            this.getArgumentsTableModel().addRow(argument);
        }
    }

    private ArgumentsTableModel getArgumentsTableModel() {
        return (ArgumentsTableModel)super.getModel();
    }
}

