/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.argumentsdefinition;

import oracle.bpm.designer.argumentsdefinition.ArgumentsTable;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.catalog.AccessType;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.TabbedPane;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;

public class ArgumentsDefinitionPanel
extends Panel {
    private ArgumentsTable inputsTable;
    private ArgumentsTable outputsTable;

    public ArgumentsDefinitionPanel(@NotNull UiContainer parent, DataDeclarationContainer inputsContainer, DataDeclarationContainer outputsContainer, boolean arraysSupported) {
        super(parent);
        this.init(inputsContainer, outputsContainer, arraysSupported);
    }

    public void setEnabled(boolean enabled) {
        if (this.hasInputs()) {
            this.inputsTable.setEnabled(enabled);
        }
        if (this.hasOutputs()) {
            this.outputsTable.setEnabled(enabled);
        }
    }

    public boolean isEnabled() {
        return this.hasInputs() && this.inputsTable.isEnabled() || this.hasOutputs() && this.outputsTable.isEnabled();
    }

    public DataDeclarationContainer getInputArgumentsContainer() {
        return this.hasInputs() ? this.inputsTable.getArgumentsContainer() : null;
    }

    public DataDeclarationContainer getOutputsArgumentsContainer() {
        return this.hasOutputs() ? this.outputsTable.getArgumentsContainer() : null;
    }

    private void init(DataDeclarationContainer inputsContainer, DataDeclarationContainer outputsContainer, boolean arraysSupported) {
        this.setLayout((Layout)new MigLayout("ins 0, gap 0, fill"));
        UiContainer container = inputsContainer != null && outputsContainer != null ? this.buildTabbedPane((UiContainer)this) : this.buildPanel((UiContainer)this);
        this.add((UiComponent)container, "grow");
        if (inputsContainer != null) {
            this.inputsTable = ArgumentsTable.create(container, inputsContainer, AccessType.IN, arraysSupported);
            this.addTable(container, this.inputsTable, DesignerMsg.INPUT);
        }
        if (outputsContainer != null) {
            this.outputsTable = ArgumentsTable.create(container, outputsContainer, AccessType.OUT, arraysSupported);
            this.addTable(container, this.outputsTable, DesignerMsg.OUTPUT);
        }
    }

    private void addTable(@NotNull UiContainer container, @NotNull ArgumentsTable table, @NotNull Msg title) {
        if (container instanceof TabbedPane) {
            TabbedPane tabbedPane = (TabbedPane)container;
            tabbedPane.addTab(title, (UiComponent)table);
        } else {
            container.add((UiComponent)table, (Object)"grow");
        }
    }

    private UiContainer buildTabbedPane(@NotNull UiContainer parent) {
        return new TabbedPane(parent);
    }

    private UiContainer buildPanel(@NotNull UiContainer parent) {
        Panel result = new Panel(parent);
        result.setLayout((Layout)new MigLayout("ins 0, gap 0, fill"));
        return result;
    }

    private boolean hasInputs() {
        return this.inputsTable != null;
    }

    private boolean hasOutputs() {
        return this.outputsTable != null;
    }
}

