/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.activityguide;

import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.TranslationService;
import oracle.bpm.project.activityguide.ResourceBundleImpl;
import oracle.bpm.project.model.activityguide.ActivityGuide;
import oracle.bpm.project.model.activityguide.TranslatableValue;
import oracle.bpm.project.model.activityguide.TranslationType;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.text.TextComponent;
import org.jetbrains.annotations.NotNull;

public class UiTranslationHelper {
    private ActivityGuide activityGuide;
    private TranslationService translationService;
    private UiContainer uiParent;

    private UiTranslationHelper(ActivityGuide activityGuide, UiContainer uiParent) {
        this.activityGuide = activityGuide;
        this.uiParent = uiParent;
    }

    public static UiTranslationHelper create(@NotNull ActivityGuide activityGuide, UiContainer uiParent) {
        return new UiTranslationHelper(activityGuide, uiParent);
    }

    public String getTranslatedValue(TranslatableValue translatableValue) {
        if (translatableValue.getType() == TranslationType.RESOURCE && this.getTranslationService() != null) {
            return this.getTranslationService().translate(translatableValue.getValue());
        }
        return translatableValue.getValue();
    }

    public String getTranslatedValue(String key) {
        return this.getTranslationService().translate(key);
    }

    public TranslationService getTranslationService() {
        if (this.translationService == null) {
            this.translationService = AbstractStudioWorkbench.getInstance().getTranslationService(this.uiParent, this.activityGuide.getProject(), ResourceBundleImpl.getDefaultResourceBundle());
        }
        return this.translationService;
    }

    public ActionListener getLocalizedButtonActionListener(final ComboBox<TranslationType> translationTypeCombo, final TextComponent textComponent) {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String selectedKey;
                String currentKey;
                String string = currentKey = translationTypeCombo.getSelectedItem() == TranslationType.RESOURCE ? textComponent.getName() : null;
                if (UiTranslationHelper.this.getTranslationService() != null && (selectedKey = UiTranslationHelper.this.getTranslationService().browseResourceBundle(UiTranslationHelper.this.uiParent, currentKey)) != null) {
                    textComponent.setName(selectedKey);
                    textComponent.setText(UiTranslationHelper.this.getTranslationService().translate(selectedKey));
                }
            }
        };
    }
}

