/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.activityguide;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.log.Log;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.selection.Selection;

public class MoveUpPositionableProjectObjectAction
extends BaseAction {
    private ProjectObjectContainer positionableChildren;
    private ProjectObject projectObject;

    public MoveUpPositionableProjectObjectAction(ProjectObjectContainer positionableChildren, ProjectObject projectObject) {
        this.requires(ProjectObject.class);
        this.setMsg(DesignerMsg.MOVE_UP_MILESTONE_ACTIVITY);
        this.projectObject = projectObject;
        this.positionableChildren = positionableChildren;
    }

    public void run() {
        this.moveUp();
    }

    public ProjectObject getProjectObject() {
        return this.projectObject;
    }

    public ProjectObjectContainer getObjectContainer() {
        return this.positionableChildren;
    }

    protected void updateEnableStatus(Selection s) {
        this.setEnabled(this.getObjectContainer().indexOf(this.getProjectObject()) > 0);
    }

    private void moveUp() {
        try {
            this.getObjectContainer().moveChild(this.getProjectObject(), this.getObjectContainer().indexOf(this.getProjectObject()) - 1);
        }
        catch (ProjectException e) {
            Log.logSevere(e);
        }
    }
}

