/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.activityguide;

import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.log.Log;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.selection.Selection;

public class MoveDownPositionableProjectObjectAction
extends BaseAction {
    private ProjectObjectContainer objectContainer;
    private ProjectObject positionable;

    public MoveDownPositionableProjectObjectAction(ProjectObjectContainer objectContainer, ProjectObject positionable) {
        this.requires(ProjectObject.class);
        this.setMsg(DesignerMsg.MOVE_DOWN_MILESTONE_ACTIVITY);
        this.positionable = positionable;
        this.objectContainer = objectContainer;
    }

    public void run() {
        this.moveDown();
    }

    public ProjectObject getProjectObject() {
        return this.positionable;
    }

    public ProjectObjectContainer getObjectContainer() {
        return this.objectContainer;
    }

    protected void updateEnableStatus(Selection s) {
        int position = this.getObjectContainer().indexOf(this.getProjectObject());
        this.setEnabled(position < CollectionUtils.size(this.getObjectContainer().getChildren()) - 1);
    }

    private void moveDown() {
        try {
            this.getObjectContainer().moveChild(this.getProjectObject(), this.getObjectContainer().indexOf(this.getProjectObject()) + 1);
        }
        catch (ProjectException e) {
            Log.logSevere(e);
        }
    }
}

