/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.activityguide;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import oracle.bpm.collections.Predicate;
import oracle.bpm.designer.DesignerUtils;
import oracle.bpm.designer.activityguide.MilestoneCompositeValidator;
import oracle.bpm.designer.activityguide.UiTranslationHelper;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.validator.ValidationException;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.io.fs.VFileUtils;
import oracle.bpm.log.Log;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.activityguide.ActivityGuide;
import oracle.bpm.project.model.activityguide.DisplayMode;
import oracle.bpm.project.model.activityguide.Milestone;
import oracle.bpm.project.model.activityguide.TranslatableValue;
import oracle.bpm.project.model.activityguide.TranslationType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.filechooser.FileChooser;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.text.NumericField;
import oracle.bpm.ui.text.TextArea;
import oracle.bpm.ui.text.TextComponent;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.util.FileFilter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MilestonePropertiesPanel
extends Panel {
    private ActivityGuide activityGuide;
    private TextArea descriptionField;
    private Button descriptionLocalizedButton;
    private ComboBox<TranslationType> descriptionTypeComboBox;
    private ComboBox<DisplayMode> displayModeComboBox;
    private TextField iconLocationTextField;
    private Milestone milestone;
    private NumericField<Integer> tasksRemainingTextField;
    private Button titleLocalizedButton;
    private TextField titleTextField;
    private ComboBox<TranslationType> titleTypeComboBox;
    private UiTranslationHelper uiTranslationHelper;

    public MilestonePropertiesPanel(UiContainer contentPane, ActivityGuide activityGuide) {
        this(contentPane, activityGuide, null);
    }

    public MilestonePropertiesPanel(UiContainer parent, @NotNull ActivityGuide activityGuide, Milestone milestone) {
        super(parent);
        this.milestone = milestone;
        this.activityGuide = activityGuide;
        this.uiTranslationHelper = UiTranslationHelper.create(activityGuide, (UiContainer)this);
        this.setLayout((Layout)new BorderLayout());
        this.buildUi();
    }

    public String getTitle() {
        return this.titleTextField.getText();
    }

    public String getDescription() {
        return this.descriptionField.getText();
    }

    public String getIconLocation() {
        return this.iconLocationTextField.getText();
    }

    public DisplayMode getDisplayMode() {
        return (DisplayMode)this.displayModeComboBox.getSelectedItem();
    }

    public int getTasksRemaining() {
        return (Integer)this.tasksRemainingTextField.getValue();
    }

    public Milestone fillValues() throws ProjectException, ValidationException {
        this.validatePanel();
        if (this.milestone == null) {
            this.milestone = this.activityGuide.createMilestone(this.generateId());
        } else {
            this.milestone.setId(this.generateId());
        }
        if (this.titleTypeComboBox.getSelectedItem() == TranslationType.STATIC || this.activityGuide.getResourceBundle().isExternal()) {
            this.milestone.getTranslatableTitle().setValue(this.getTitle());
        } else {
            this.milestone.getTranslatableTitle().setValue(this.titleTextField.getName());
        }
        this.milestone.getTranslatableTitle().setType((TranslationType)this.titleTypeComboBox.getSelectedItem());
        if (this.descriptionTypeComboBox.getSelectedItem() == TranslationType.STATIC || this.activityGuide.getResourceBundle().isExternal()) {
            this.milestone.getTranslatableDescription().setValue(this.getDescription());
        } else {
            this.milestone.getTranslatableDescription().setValue(this.descriptionField.getName());
        }
        this.milestone.getTranslatableDescription().setType((TranslationType)this.descriptionTypeComboBox.getSelectedItem());
        this.milestone.setIconLocation(this.getIconLocation());
        this.milestone.setDisplayMode(this.getDisplayMode());
        this.milestone.setTasksRemaining(this.getTasksRemaining());
        return this.milestone;
    }

    public void populateValues() {
        if (this.milestone != null) {
            TranslatableValue translatableTitle = this.milestone.getTranslatableTitle();
            if (translatableTitle.getType() == TranslationType.RESOURCE && !this.activityGuide.getResourceBundle().isExternal()) {
                this.titleTextField.setText(this.uiTranslationHelper.getTranslatedValue(translatableTitle));
                this.titleTextField.setName(translatableTitle.getValue());
                this.titleTextField.setEnabled(false);
                this.titleTextField.setEditable(false);
            } else {
                this.titleTextField.setText(translatableTitle.getValue());
            }
            TranslatableValue translatableDescription = this.milestone.getTranslatableDescription();
            if (translatableDescription.getType() == TranslationType.RESOURCE && !this.activityGuide.getResourceBundle().isExternal()) {
                this.descriptionField.setText(this.uiTranslationHelper.getTranslatedValue(translatableDescription));
                this.descriptionField.setName(translatableDescription.getValue());
                this.descriptionField.setEnabled(false);
                this.descriptionField.setEditable(false);
            } else {
                this.descriptionField.setText(translatableDescription.getValue());
            }
            this.iconLocationTextField.setText(this.milestone.getIconLocation());
            this.displayModeComboBox.setSelectedItem((Object)this.milestone.getDisplayMode());
            this.tasksRemainingTextField.setValue((Number)this.milestone.getTasksRemaining());
            this.titleLocalizedButton.setEnabled(!this.activityGuide.getResourceBundle().isExternal() && this.milestone.getTranslatableTitle().getType() == TranslationType.RESOURCE);
            this.descriptionLocalizedButton.setEnabled(!this.activityGuide.getResourceBundle().isExternal() && this.milestone.getTranslatableDescription().getType() == TranslationType.RESOURCE);
        }
        this.titleLocalizedButton.setEnabled(!this.activityGuide.getResourceBundle().isExternal() && this.titleTypeComboBox.getSelectedItem() == TranslationType.RESOURCE);
        this.descriptionLocalizedButton.setEnabled(!this.activityGuide.getResourceBundle().isExternal() && this.descriptionTypeComboBox.getSelectedItem() == TranslationType.RESOURCE);
    }

    private Predicate<String> getMilestoneExistsPredicate() {
        return new Predicate<String>(){

            @Override
            public boolean check(@Nullable String value) {
                return MilestonePropertiesPanel.this.activityGuide.findChild(Milestone.class, value) != null;
            }
        };
    }

    private String generateId() {
        return this.getTitle().replaceAll(" ", "_");
    }

    private void validatePanel() throws ValidationException {
        Msg errorMsg = new MilestoneCompositeValidator(this.activityGuide, this.milestone).validate(this.generateId());
        if (errorMsg != null) {
            throw new ValidationException(errorMsg);
        }
    }

    private void buildUi() {
        Panel panel = Panel.createPanelWithBorder((UiContainer)this);
        panel.setLayout((Layout)new MigLayout("fillx, gapx 5, ins 5"));
        Panel titlePanel = this.buildTitlePanel((UiContainer)panel);
        Panel descriptionPanel = this.buildDescriptionPanel((UiContainer)panel);
        Panel iconPanel = this.buildIconPanel((UiContainer)panel);
        this.displayModeComboBox = UiFactory.createComboBox((UiContainer)panel, (Object[])DisplayMode.values());
        this.displayModeComboBox.setLabelProvider(this.getDisplayModeLabelProvider());
        this.tasksRemainingTextField = NumericField.createIntegerNumericField((UiContainer)panel);
        this.tasksRemainingTextField.setMinimum((Number)1);
        this.tasksRemainingTextField.setValue((Number)1);
        this.populateValues();
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)DesignerMsg.TITLE));
        panel.add((UiComponent)titlePanel, (Object)"growx, wrap");
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)DesignerMsg.DESCRIPTION));
        panel.add((UiComponent)descriptionPanel, (Object)"growx, wrap");
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)DesignerMsg.ICON_LOCATION));
        panel.add((UiComponent)iconPanel, (Object)"growx, wrap");
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)DesignerMsg.DISPLAY_MODE));
        panel.add(this.displayModeComboBox, (Object)"wrap");
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)DesignerMsg.TASKS_REMAINING));
        panel.add(this.tasksRemainingTextField);
        this.add((UiComponent)panel, "Center");
    }

    private Panel buildTitlePanel(UiContainer container) {
        Panel panel = new Panel(container);
        panel.setLayout((Layout)new MigLayout("fillx, ins 0, gapx 5"));
        this.titleTextField = new TextField((UiContainer)panel);
        this.titleTextField.setText(DesignerUtils.getSuggestedName(ProjectMsg.MILESTONE.getString(), this.getMilestoneExistsPredicate()));
        this.titleTextField.requestFocus();
        this.titleTypeComboBox = UiFactory.createComboBox((UiContainer)panel, (Object[])TranslationType.values());
        this.titleTypeComboBox.setLabelProvider(this.getTranslationTypeLabelProvider());
        this.titleTypeComboBox.setSelectedItem((Object)(this.milestone != null ? this.milestone.getTranslatableTitle().getType() : TranslationType.STATIC));
        this.titleLocalizedButton = new Button((UiContainer)panel, Image.create((Msg)DesignerMsg.LOCALIZED_MESSAGE));
        Button.fixSize((Button)this.titleLocalizedButton);
        this.titleLocalizedButton.addActionListener(this.uiTranslationHelper.getLocalizedButtonActionListener(this.titleTypeComboBox, (TextComponent)this.titleTextField));
        this.titleTypeComboBox.addItemListener(this.getTranslationTypeItemListener(this.titleLocalizedButton, (TextComponent)this.titleTextField));
        panel.add(this.titleTypeComboBox);
        panel.add((UiComponent)this.titleTextField, (Object)"growx");
        panel.add((UiComponent)this.titleLocalizedButton, (Object)"wrap");
        return panel;
    }

    private Panel buildDescriptionPanel(UiContainer container) {
        Panel panel = new Panel(container);
        panel.setLayout((Layout)new MigLayout("fillx, ins 0, gapx 5"));
        this.descriptionTypeComboBox = UiFactory.createComboBox((UiContainer)panel, (Object[])TranslationType.values());
        this.descriptionTypeComboBox.setSelectedItem((Object)(this.milestone != null ? this.milestone.getTranslatableDescription().getType() : TranslationType.STATIC));
        this.descriptionTypeComboBox.setLabelProvider(this.getTranslationTypeLabelProvider());
        this.descriptionField = new TextArea((UiContainer)panel);
        this.descriptionField.setColumns(30);
        this.descriptionField.setRows(4);
        this.descriptionLocalizedButton = new Button((UiContainer)panel, Image.create((Msg)DesignerMsg.LOCALIZED_MESSAGE));
        Button.fixSize((Button)this.descriptionLocalizedButton);
        this.descriptionLocalizedButton.addActionListener(this.uiTranslationHelper.getLocalizedButtonActionListener(this.descriptionTypeComboBox, (TextComponent)this.descriptionField));
        this.descriptionTypeComboBox.addItemListener(this.getTranslationTypeItemListener(this.descriptionLocalizedButton, (TextComponent)this.descriptionField));
        panel.add(this.descriptionTypeComboBox);
        panel.add((UiComponent)this.descriptionField, (Object)"growx");
        panel.add((UiComponent)this.descriptionLocalizedButton, (Object)"aligny top, wrap");
        return panel;
    }

    private Panel buildIconPanel(UiContainer container) {
        Panel panel = new Panel(container);
        panel.setLayout((Layout)new MigLayout("fillx, ins 0, gapx 5"));
        this.iconLocationTextField = new TextField((UiContainer)panel, 30);
        Button browseIconButton = Button.createBrowse((UiContainer)panel);
        browseIconButton.addActionListener(this.getIconLocationActionListener());
        panel.add((UiComponent)this.iconLocationTextField, (Object)"growx");
        panel.add((UiComponent)browseIconButton, (Object)"wrap");
        return panel;
    }

    private LabelProvider<DisplayMode> getDisplayModeLabelProvider() {
        return new LabelProvider<DisplayMode>(){

            public Image getIcon(DisplayMode element) {
                return null;
            }

            public String getText(DisplayMode element) {
                return element.getLabel().toString();
            }
        };
    }

    private ActionListener getIconLocationActionListener() {
        return new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void actionPerformed(ActionEvent e) {
                FileChooser fileChooser = new FileChooser();
                fileChooser.setFileFilter(FileFilter.create(DesignerMsg.GIF_IMAGE, ".gif", ".jpg", ".jpeg", ".jpe"));
                fileChooser.showOpenDialog((UiComponent)MilestonePropertiesPanel.this, DesignerMsg.BROWSE_ICONS);
                VFileSystem dataFileSystem = MilestonePropertiesPanel.this.activityGuide.getProject().getLoader().getProjectFileSystem().getDataFileSystem();
                VFile resourcesDirectory = dataFileSystem.createFile(Path.RESOURCES.getName());
                File imageFile = fileChooser.getSelectedFile();
                if (imageFile != null) {
                    FileInputStream imageFileIS = null;
                    try {
                        VFile destinationVFile = dataFileSystem.createFile(resourcesDirectory, imageFile.getName());
                        if (!destinationVFile.exists()) {
                            imageFileIS = new FileInputStream(imageFile);
                            VFileUtils.fileCopy((InputStream)imageFileIS, (VFile)destinationVFile);
                        }
                        MilestonePropertiesPanel.this.iconLocationTextField.setText(destinationVFile.toString().replaceFirst("/", ""));
                    }
                    catch (FileNotFoundException e1) {
                        Log.logSevere(e1);
                        StreamUtils.close(imageFileIS);
                    }
                    catch (IOException e12) {
                        Log.logSevere(e12);
                        {
                            catch (Throwable throwable) {
                                StreamUtils.close(imageFileIS);
                                throw throwable;
                            }
                        }
                        StreamUtils.close(imageFileIS);
                    }
                    StreamUtils.close(imageFileIS);
                }
            }
        };
    }

    private LabelProvider<TranslationType> getTranslationTypeLabelProvider() {
        return new LabelProvider<TranslationType>(){

            public Image getIcon(TranslationType element) {
                return null;
            }

            public String getText(TranslationType element) {
                return element.getMsg().toString();
            }
        };
    }

    private ItemListener getTranslationTypeItemListener(final Button localizedButton, final TextComponent textComponent) {
        return new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                TranslationType translatableType = (TranslationType)e.getItem();
                localizedButton.setEnabled(!MilestonePropertiesPanel.this.activityGuide.getResourceBundle().isExternal() && translatableType == TranslationType.RESOURCE);
                textComponent.setEnabled(translatableType == TranslationType.STATIC);
                textComponent.setEditable(translatableType == TranslationType.STATIC);
                if (translatableType == TranslationType.STATIC) {
                    textComponent.setName("");
                } else {
                    textComponent.setText("");
                    textComponent.setName("");
                }
            }
        };
    }
}

