/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.activityguide;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.validator.CompositeValidator;
import oracle.bpm.designer.validator.EmptyNameValidator;
import oracle.bpm.designer.validator.StringValidator;
import oracle.bpm.project.model.activityguide.ActivityGuide;
import oracle.bpm.project.model.activityguide.Milestone;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MilestoneCompositeValidator
extends CompositeValidator<String> {
    private ActivityGuide activityGuide;

    public MilestoneCompositeValidator(@NotNull ActivityGuide activityGuide, @Nullable Milestone milestone) {
        this.activityGuide = activityGuide;
        super.addValidator(new EmptyNameValidator(DesignerMsg.TITLE));
        super.addValidator(new DuplicatedMilestoneValidator(milestone));
    }

    private class DuplicatedMilestoneValidator
    extends StringValidator {
        private Milestone milestone;

        public DuplicatedMilestoneValidator(Milestone milestone) {
            this.milestone = milestone;
        }

        @Override
        public Msg validate(String milestoneId) {
            Milestone milestoneFound = (Milestone)MilestoneCompositeValidator.this.activityGuide.findChild(Milestone.class, milestoneId);
            if (milestoneFound != null && this.milestone != milestoneFound) {
                return DesignerMsg.OBJECT_ALREADY_EXISTS(DesignerMsg.MILESTONE_TITLE, milestoneId);
            }
            return null;
        }
    }
}

