/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.activityguide;

import oracle.bpm.designer.activityguide.MilestonesComboBox;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.activityguide.Milestone;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.forms.FormsFactory;
import oracle.bpm.ui.forms.StandardForm;
import org.jetbrains.annotations.NotNull;

public abstract class FlowNodeToMilestoneDialog<T extends ProjectObject>
extends OkCancelDialog {
    private ComboBox<Milestone> availableMilestones;
    private T element;

    public FlowNodeToMilestoneDialog(UiWindow parent, Msg title, @NotNull T element) {
        super(parent, title);
        this.element = element;
        this.buildUi();
    }

    public abstract Iterable<? extends Milestone> getAvailableMilestones();

    public Project getProject() {
        return this.getElement().getProject();
    }

    public T getElement() {
        return this.element;
    }

    protected Milestone getSelectedMilestone() {
        return (Milestone)this.availableMilestones.getSelectedItem();
    }

    private void buildUi() {
        Panel mainPanel = new Panel(this.getContentPane());
        StandardForm layout = FormsFactory.createStandardForm((UiContainer)mainPanel);
        Label comboLabel = Label.create((UiContainer)mainPanel, (Msg)ProjectMsg.MILESTONES);
        this.availableMilestones = new MilestonesComboBox((UiContainer)mainPanel, false);
        Iterable<Milestone> milestones = this.getAvailableMilestones();
        this.availableMilestones.addItems(milestones);
        this.availableMilestones.setSelectedIndex(milestones.iterator().hasNext() ? 0 : -1);
        layout.add((UiComponent)comboLabel);
        layout.add(this.availableMilestones);
        this.getContentPane().add((UiComponent)mainPanel);
        this.pack();
        this.updateEnableOkButton();
        this.setLocationRelativeTo((UiComponent)this.getParent());
    }

    private void updateEnableOkButton() {
        this.okButton.setEnabled(this.availableMilestones.getItemCount() > 0);
    }
}

