/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.activityguide;

import oracle.bpm.designer.activityguide.MilestonePropertiesPanel;
import oracle.bpm.designer.validator.ValidationException;
import oracle.bpm.project.model.activityguide.ActivityGuide;
import oracle.bpm.project.model.activityguide.Milestone;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiWindow;
import org.jetbrains.annotations.NotNull;

public class EditMilestoneDialog
extends OkCancelDialog {
    private ActivityGuide activityGuide;
    private Milestone milestone;
    private MilestonePropertiesPanel milestonePanel;

    public EditMilestoneDialog(UiWindow parent, Msg msg, @NotNull Milestone milestone) {
        super(parent, msg);
        this.milestone = milestone;
        this.activityGuide = milestone.getProject().getActivityGuide();
        this.init();
    }

    public void ok() {
        try {
            this.milestonePanel.fillValues();
            this.setVisible(false);
        }
        catch (ProjectException e) {
            e.printStackTrace();
        }
        catch (ValidationException e) {
            this.milestonePanel.populateValues();
            MessageDialog.showError((Msg)e.getMsg());
        }
    }

    private void init() {
        this.milestonePanel = new MilestonePropertiesPanel(this.getContentPane(), this.activityGuide, this.milestone);
        this.getContentPane().add((UiComponent)this.milestonePanel, (Object)"Center");
        this.pack();
        this.setLocationRelativeTo((UiComponent)this.getParent());
    }
}

