/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.activityguide;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import oracle.bpm.designer.activityguide.UiTranslationHelper;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.io.fs.VFileUtils;
import oracle.bpm.log.Log;
import oracle.bpm.project.activityguide.ResourceBundleImpl;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.activityguide.ActivityGuide;
import oracle.bpm.project.model.activityguide.DisplayMode;
import oracle.bpm.project.model.activityguide.ResourceBundle;
import oracle.bpm.project.model.activityguide.TaskAccessMode;
import oracle.bpm.project.model.activityguide.TranslatableValue;
import oracle.bpm.project.model.activityguide.TranslationType;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.view.project.view.renderer.ProjectObjectRenderer;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.filechooser.FileChooser;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.text.TextArea;
import oracle.bpm.ui.text.TextComponent;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.util.FileFilter;

public class ActivityGuidePropertiesPanel
extends Panel {
    private ActivityGuide activityGuide;
    private TextArea descriptionField;
    private Button descriptionLocalizedButton;
    private ComboBox<TranslationType> descriptionTypeComboBox;
    private ComboBox<DisplayMode> displayModeComboBox;
    private CheckBox externalCheckbox;
    private TextField iconLocationTextField;
    private TextField reSrcBundleNameTextField;
    private ComboBox<Process> rootProcessComboBox;
    private ComboBox<TaskAccessMode> taskAccessModeComboBox;
    private Button titleLocalizedButton;
    private TextField titleTextField;
    private ComboBox<TranslationType> titleTypeComboBox;
    private UiTranslationHelper uiTranslationHelper;

    public ActivityGuidePropertiesPanel(UiContainer parent, ActivityGuide activityGuide) {
        super(parent);
        this.activityGuide = activityGuide;
        this.uiTranslationHelper = UiTranslationHelper.create(activityGuide, (UiContainer)this);
        this.setLayout((Layout)new BorderLayout());
        this.buildUi();
    }

    public String getTitle() {
        return this.titleTextField.getText();
    }

    public String getDescription() {
        return this.descriptionField.getText();
    }

    public String getIconLocation() {
        return this.iconLocationTextField.getText();
    }

    public Process getRootProcess() {
        return (Process)this.rootProcessComboBox.getSelectedItem();
    }

    public DisplayMode getDisplayMode() {
        return (DisplayMode)this.displayModeComboBox.getSelectedItem();
    }

    public TaskAccessMode getTaskAccessMode() {
        return (TaskAccessMode)this.taskAccessModeComboBox.getSelectedItem();
    }

    public void fillValues(ActivityGuide activityGuide) {
        if (this.titleTypeComboBox.getSelectedItem() == TranslationType.STATIC || this.externalCheckbox.isSelected()) {
            activityGuide.getTranslatableTitle().setValue(this.getTitle());
        } else {
            activityGuide.getTranslatableTitle().setValue(this.titleTextField.getName());
        }
        activityGuide.getTranslatableTitle().setType((TranslationType)this.titleTypeComboBox.getSelectedItem());
        if (this.descriptionTypeComboBox.getSelectedItem() == TranslationType.STATIC || this.externalCheckbox.isSelected()) {
            activityGuide.getTranslatableDescription().setValue(this.getDescription());
        } else {
            activityGuide.getTranslatableDescription().setValue(this.descriptionField.getName());
        }
        activityGuide.getTranslatableDescription().setType((TranslationType)this.descriptionTypeComboBox.getSelectedItem());
        activityGuide.setIconLocation(this.getIconLocation());
        ResourceBundleImpl resourceBundle = new ResourceBundleImpl(this.reSrcBundleNameTextField.getText());
        resourceBundle.setExternal(this.externalCheckbox.isSelected());
        activityGuide.setResourceBundle((ResourceBundle)resourceBundle);
        Process rootProcess = this.getRootProcess();
        if (rootProcess != null) {
            activityGuide.setRootProcess(rootProcess);
        }
        activityGuide.setDisplayMode(this.getDisplayMode());
        activityGuide.setTaskAccessMode(this.getTaskAccessMode());
    }

    private void buildUi() {
        Panel panel = Panel.createPanelWithBorder((UiContainer)this);
        panel.setLayout((Layout)new MigLayout("fillx, gapx 5, ins 5"));
        Panel titlePanel = this.buildTitlePanel((UiContainer)panel);
        Panel descriptionPanel = this.buildDescriptionPanel((UiContainer)panel);
        Panel iconPanel = this.buildIconPanel((UiContainer)panel);
        Panel resrcBundleLocationPanel = this.buildResrcBundleLocationPanel((UiContainer)panel);
        this.rootProcessComboBox = UiFactory.createComboBox((UiContainer)panel, new ArrayList(this.activityGuide.getProject().getProcesses()));
        this.rootProcessComboBox.setSelectedItem((Object)this.activityGuide.getRootProcess());
        this.rootProcessComboBox.setLabelProvider(this.getProcessLabelProvider());
        ArrayList<DisplayMode> arrayList = new ArrayList<DisplayMode>();
        arrayList.add(DisplayMode.ALWAYS);
        arrayList.add(DisplayMode.WHEN_INSTANTIATED);
        this.displayModeComboBox = UiFactory.createComboBox((UiContainer)panel, arrayList);
        this.displayModeComboBox.setSelectedItem((Object)this.activityGuide.getDisplayMode());
        this.displayModeComboBox.setLabelProvider(this.getDisplayModeLabelProvider());
        this.taskAccessModeComboBox = UiFactory.createComboBox((UiContainer)panel, (Object[])TaskAccessMode.values());
        this.taskAccessModeComboBox.setSelectedItem((Object)this.activityGuide.getTaskAccessMode());
        this.taskAccessModeComboBox.setLabelProvider(this.getTaskAccessModeLabelProvider());
        this.populateValues();
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)DesignerMsg.TITLE));
        panel.add((UiComponent)titlePanel, (Object)"growx, wrap");
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)DesignerMsg.DESCRIPTION));
        panel.add((UiComponent)descriptionPanel, (Object)"growx, wrap");
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)DesignerMsg.ICON_LOCATION));
        panel.add((UiComponent)iconPanel, (Object)"growx, wrap");
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)DesignerMsg.RESOURCE_BUNDLE));
        panel.add((UiComponent)resrcBundleLocationPanel, (Object)"growx, wrap");
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)DesignerMsg.ROOT_PROCESS));
        panel.add(this.rootProcessComboBox, (Object)"growx, wrap");
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)DesignerMsg.DISPLAY_MODE));
        panel.add(this.displayModeComboBox, (Object)"wrap");
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)DesignerMsg.TASK_ACCESS_MODE));
        panel.add(this.taskAccessModeComboBox, (Object)"wrap");
        this.add((UiComponent)panel, "Center");
    }

    private Panel buildResrcBundleLocationPanel(UiContainer parent) {
        Panel panel = new Panel(parent);
        panel.setLayout((Layout)new MigLayout("fillx"));
        this.externalCheckbox = CheckBox.create((UiContainer)panel, (Msg)DesignerMsg.EXTERNAL_RESOURCE_BUNDLE);
        this.externalCheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ActivityGuidePropertiesPanel.this.reSrcBundleNameTextField.setEnabled(ActivityGuidePropertiesPanel.this.externalCheckbox.isSelected());
                ActivityGuidePropertiesPanel.this.titleLocalizedButton.setEnabled(!ActivityGuidePropertiesPanel.this.externalCheckbox.isSelected() && ActivityGuidePropertiesPanel.this.titleTypeComboBox.getSelectedItem() == TranslationType.RESOURCE);
                ActivityGuidePropertiesPanel.this.descriptionLocalizedButton.setEnabled(!ActivityGuidePropertiesPanel.this.externalCheckbox.isSelected() && ActivityGuidePropertiesPanel.this.descriptionTypeComboBox.getSelectedItem() == TranslationType.RESOURCE);
                boolean enableTranslatableFields = ActivityGuidePropertiesPanel.this.externalCheckbox.isSelected() || ActivityGuidePropertiesPanel.this.titleTypeComboBox.getSelectedItem() == TranslationType.STATIC;
                ActivityGuidePropertiesPanel.this.titleTextField.setEnabled(enableTranslatableFields);
                ActivityGuidePropertiesPanel.this.titleTextField.setEditable(enableTranslatableFields);
                ActivityGuidePropertiesPanel.this.descriptionField.setEnabled(enableTranslatableFields);
                ActivityGuidePropertiesPanel.this.descriptionField.setEditable(enableTranslatableFields);
                if (!ActivityGuidePropertiesPanel.this.externalCheckbox.isSelected()) {
                    ActivityGuidePropertiesPanel.this.reSrcBundleNameTextField.setText("ActivityGuide");
                    ActivityGuidePropertiesPanel.this.titleTextField.setText(ActivityGuidePropertiesPanel.this.uiTranslationHelper.getTranslatedValue(ActivityGuidePropertiesPanel.this.titleTextField.getName()));
                    ActivityGuidePropertiesPanel.this.descriptionField.setText(ActivityGuidePropertiesPanel.this.uiTranslationHelper.getTranslatedValue(ActivityGuidePropertiesPanel.this.descriptionField.getName()));
                } else {
                    ActivityGuidePropertiesPanel.this.reSrcBundleNameTextField.setText(ActivityGuidePropertiesPanel.this.activityGuide.getResourceBundle().getName());
                    ActivityGuidePropertiesPanel.this.titleTextField.setText(ActivityGuidePropertiesPanel.this.titleTextField.getName());
                    ActivityGuidePropertiesPanel.this.descriptionField.setText(ActivityGuidePropertiesPanel.this.descriptionField.getName());
                }
            }
        });
        this.reSrcBundleNameTextField = new TextField((UiContainer)panel);
        panel.add((UiComponent)this.externalCheckbox, (Object)"wrap");
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)DesignerMsg.RESOURCE_BUNDLE_NAME));
        panel.add((UiComponent)this.reSrcBundleNameTextField, (Object)"growx");
        return panel;
    }

    private Panel buildTitlePanel(UiContainer container) {
        Panel panel = new Panel(container);
        panel.setLayout((Layout)new MigLayout("fillx, ins 0, gapx 5"));
        this.titleTextField = new TextField((UiContainer)panel);
        this.titleTypeComboBox = UiFactory.createComboBox((UiContainer)panel, (Object[])TranslationType.values());
        this.titleTypeComboBox.setLabelProvider(this.getTranslationTypeLabelProvider());
        this.titleTypeComboBox.setSelectedItem((Object)this.activityGuide.getTranslatableTitle().getType());
        this.titleLocalizedButton = new Button((UiContainer)panel, Image.create((Msg)DesignerMsg.LOCALIZED_MESSAGE));
        Button.fixSize((Button)this.titleLocalizedButton);
        this.titleLocalizedButton.addActionListener(this.uiTranslationHelper.getLocalizedButtonActionListener(this.titleTypeComboBox, (TextComponent)this.titleTextField));
        this.titleTypeComboBox.addItemListener(this.getTranslationTypeItemListener(this.titleLocalizedButton, (TextComponent)this.titleTextField));
        panel.add(this.titleTypeComboBox);
        panel.add((UiComponent)this.titleTextField, (Object)"growx");
        panel.add((UiComponent)this.titleLocalizedButton, (Object)"wrap");
        return panel;
    }

    private Panel buildDescriptionPanel(UiContainer container) {
        Panel panel = new Panel(container);
        panel.setLayout((Layout)new MigLayout("fillx, ins 0, gapx 5"));
        this.descriptionTypeComboBox = UiFactory.createComboBox((UiContainer)panel, (Object[])TranslationType.values());
        this.descriptionTypeComboBox.setSelectedItem((Object)this.activityGuide.getTranslatableDescription().getType());
        this.descriptionTypeComboBox.setLabelProvider(this.getTranslationTypeLabelProvider());
        this.descriptionField = new TextArea((UiContainer)panel);
        this.descriptionField.setColumns(30);
        this.descriptionField.setRows(4);
        this.descriptionLocalizedButton = new Button((UiContainer)panel, Image.create((Msg)DesignerMsg.LOCALIZED_MESSAGE));
        Button.fixSize((Button)this.descriptionLocalizedButton);
        this.descriptionLocalizedButton.addActionListener(this.uiTranslationHelper.getLocalizedButtonActionListener(this.descriptionTypeComboBox, (TextComponent)this.descriptionField));
        this.descriptionTypeComboBox.addItemListener(this.getTranslationTypeItemListener(this.descriptionLocalizedButton, (TextComponent)this.descriptionField));
        panel.add(this.descriptionTypeComboBox);
        panel.add((UiComponent)this.descriptionField, (Object)"growx");
        panel.add((UiComponent)this.descriptionLocalizedButton, (Object)"aligny top, wrap");
        return panel;
    }

    private Panel buildIconPanel(UiContainer container) {
        Panel panel = new Panel(container);
        panel.setLayout((Layout)new MigLayout("fillx, ins 0, gapx 5"));
        this.iconLocationTextField = new TextField((UiContainer)panel, 30);
        Button browseIconButton = Button.createBrowse((UiContainer)panel);
        browseIconButton.addActionListener(this.getIconLocationActionListener());
        panel.add((UiComponent)this.iconLocationTextField, (Object)"growx");
        panel.add((UiComponent)browseIconButton, (Object)"wrap");
        return panel;
    }

    private LabelProvider<TaskAccessMode> getTaskAccessModeLabelProvider() {
        return new LabelProvider<TaskAccessMode>(){

            public Image getIcon(TaskAccessMode element) {
                return null;
            }

            public String getText(TaskAccessMode element) {
                return element.getLabel().toString();
            }
        };
    }

    private LabelProvider<DisplayMode> getDisplayModeLabelProvider() {
        return new LabelProvider<DisplayMode>(){

            public Image getIcon(DisplayMode element) {
                return null;
            }

            public String getText(DisplayMode element) {
                return element.getLabel().toString();
            }
        };
    }

    private LabelProvider<Process> getProcessLabelProvider() {
        return new LabelProvider<Process>(){

            public Image getIcon(Process element) {
                return null;
            }

            public String getText(Process element) {
                return ProjectObjectRenderer.Default.getLabel((ProjectObject)element);
            }
        };
    }

    private void populateValues() {
        ResourceBundle resourceBundle = this.activityGuide.getResourceBundle();
        TranslatableValue translatableTitle = this.activityGuide.getTranslatableTitle();
        if (translatableTitle.getType() == TranslationType.RESOURCE && !this.activityGuide.getResourceBundle().isExternal()) {
            this.titleTextField.setText(this.uiTranslationHelper.getTranslatedValue(translatableTitle));
            this.titleTextField.setName(translatableTitle.getValue());
            this.titleTextField.setEnabled(false);
            this.titleTextField.setEditable(false);
        } else {
            this.titleTextField.setText(translatableTitle.getValue());
            this.titleTextField.setName(translatableTitle.getValue());
        }
        this.titleLocalizedButton.setEnabled(!resourceBundle.isExternal() && this.activityGuide.getTranslatableTitle().getType() == TranslationType.RESOURCE);
        TranslatableValue translatableDescription = this.activityGuide.getTranslatableDescription();
        if (translatableDescription.getType() == TranslationType.RESOURCE && !resourceBundle.isExternal()) {
            this.descriptionField.setText(this.uiTranslationHelper.getTranslatedValue(this.activityGuide.getTranslatableDescription()));
            this.descriptionField.setName(translatableDescription.getValue());
            this.descriptionField.setEnabled(false);
            this.descriptionField.setEditable(false);
        } else {
            this.descriptionField.setText(translatableDescription.getValue());
            this.descriptionField.setName(translatableDescription.getValue());
        }
        this.descriptionLocalizedButton.setEnabled(!resourceBundle.isExternal() && this.activityGuide.getTranslatableDescription().getType() == TranslationType.RESOURCE);
        this.iconLocationTextField.setText(this.activityGuide.getIconLocation());
        this.externalCheckbox.setSelected(resourceBundle.isExternal());
        if (resourceBundle != null) {
            this.reSrcBundleNameTextField.setText(resourceBundle.getName());
        }
        this.reSrcBundleNameTextField.setEnabled(resourceBundle.isExternal());
        if (this.activityGuide.getRootProcess() != null) {
            this.rootProcessComboBox.setSelectedItem((Object)this.activityGuide.getRootProcess());
        }
    }

    private ItemListener getTranslationTypeItemListener(final Button localizedButton, final TextComponent textComponent) {
        return new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                TranslationType translationType = (TranslationType)e.getItem();
                localizedButton.setEnabled(!ActivityGuidePropertiesPanel.this.externalCheckbox.isSelected() && translationType == TranslationType.RESOURCE);
                textComponent.setEnabled(ActivityGuidePropertiesPanel.this.externalCheckbox.isSelected() || translationType == TranslationType.STATIC);
                textComponent.setEditable(ActivityGuidePropertiesPanel.this.externalCheckbox.isSelected() || translationType == TranslationType.STATIC);
                if (translationType == TranslationType.STATIC) {
                    textComponent.setName("");
                } else {
                    textComponent.setText("");
                    textComponent.setName("");
                }
            }
        };
    }

    private LabelProvider<TranslationType> getTranslationTypeLabelProvider() {
        return new LabelProvider<TranslationType>(){

            public Image getIcon(TranslationType element) {
                return null;
            }

            public String getText(TranslationType element) {
                return element.getMsg().toString();
            }
        };
    }

    private ActionListener getIconLocationActionListener() {
        return new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void actionPerformed(ActionEvent e) {
                FileChooser fileChooser = new FileChooser();
                fileChooser.setFileFilter(FileFilter.create(DesignerMsg.GIF_IMAGE, ".gif", ".jpg", ".jpeg", ".jpe"));
                fileChooser.showOpenDialog((UiComponent)ActivityGuidePropertiesPanel.this, DesignerMsg.BROWSE_ICONS);
                VFileSystem dataFileSystem = ActivityGuidePropertiesPanel.this.activityGuide.getProject().getLoader().getProjectFileSystem().getDataFileSystem();
                VFile resourcesDirectory = dataFileSystem.createFile(Path.RESOURCES.getName());
                File imageFile = fileChooser.getSelectedFile();
                if (imageFile != null) {
                    FileInputStream imageFileIS = null;
                    try {
                        VFile destinationVFile = dataFileSystem.createFile(resourcesDirectory, imageFile.getName());
                        if (!destinationVFile.exists()) {
                            imageFileIS = new FileInputStream(imageFile);
                            VFileUtils.fileCopy((InputStream)imageFileIS, (VFile)destinationVFile);
                        }
                        ActivityGuidePropertiesPanel.this.iconLocationTextField.setText(destinationVFile.toString().replaceFirst("/", ""));
                    }
                    catch (FileNotFoundException e1) {
                        Log.logSevere(e1);
                        StreamUtils.close(imageFileIS);
                    }
                    catch (IOException e12) {
                        Log.logSevere(e12);
                        {
                            catch (Throwable throwable) {
                                StreamUtils.close(imageFileIS);
                                throw throwable;
                            }
                        }
                        StreamUtils.close(imageFileIS);
                    }
                    StreamUtils.close(imageFileIS);
                }
            }
        };
    }
}

