/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.activitiespanels;

import oracle.bpm.compiler.InvalidLanguageException;
import oracle.bpm.compiler.LanguageSpec;
import oracle.bpm.designer.activitiespanels.BooleanFeatureEditor;
import oracle.bpm.designer.activitiespanels.FeatureEditor;
import oracle.bpm.designer.editor.PlainEditor;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.editor.CodeEditor;
import oracle.bpm.editor.EditorPreferences;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.XPathExpression;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.BooleanFeature;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.ActivityExpressionFeature;
import oracle.bpm.project.model.processes.LoopFeature;
import oracle.bpm.ui.AbstractButton;
import oracle.bpm.ui.ButtonGroup;
import oracle.bpm.ui.LabelMultiline;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.AttributeConstraint;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.Constraint;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.layout.border.BorderLayout;

class LoopFeatureEditor
extends FeatureEditor<LoopFeature> {
    private RadioButton afterButton;
    private RadioButton beforeButton;
    private BooleanFeatureEditor enableFeatureEditor;
    private CodeEditor expressionPanel;

    public LoopFeatureEditor(UiContainer parent, LoopFeature info) {
        super(parent, info, true);
        this.build();
    }

    @Override
    public void toFeature() {
        this.enableFeatureEditor.toFeature();
        LoopFeature.BeforeAfterFeature beforeAfterFeature = ((LoopFeature)this.getFeature()).getBeforeAfter();
        beforeAfterFeature.setValue(Boolean.valueOf(this.beforeButton.isSelected()));
        ActivityExpressionFeature expressionFeature = ((LoopFeature)this.getFeature()).getExpression();
        expressionFeature.setValue((Expression)new XPathExpression(this.expressionPanel.getText()));
    }

    @Override
    public void fromFeature() {
        this.enableFeatureEditor.fromFeature();
        LoopFeature.BeforeAfterFeature beforeAfterFeature = ((LoopFeature)this.getFeature()).getBeforeAfter();
        this.beforeButton.setSelected(beforeAfterFeature.getValue().booleanValue());
        this.afterButton.setSelected(beforeAfterFeature.getValue() == false);
        ActivityExpressionFeature expressionFeature = ((LoopFeature)this.getFeature()).getExpression();
        this.expressionPanel.setText(expressionFeature.getValue().getExpressionValue());
        this.enableChanged();
    }

    @Override
    public void check() throws ProjectException {
    }

    private void build() {
        RelativeLayout containerLayout = new RelativeLayout();
        this.setLayout((Layout)containerLayout);
        this.enableFeatureEditor = BooleanFeatureEditor.create((UiContainer)this, (BooleanFeature)((LoopFeature)this.getFeature()).getEnable());
        Panel beforeAfterPanel = this.createBeforeAfterPanel((UiContainer)this);
        Panel panel = this.createExpressionPanel((UiContainer)this);
        this.enableFeatureEditor.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                LoopFeatureEditor.this.enableChanged();
            }
        });
        this.add((UiComponent)this.enableFeatureEditor, "enable");
        this.add((UiComponent)beforeAfterPanel, "centerPanel");
        this.add((UiComponent)panel, "expression");
        containerLayout.addConstraint("enable", AttributeType.TOP, (Constraint)new AttributeConstraint("_container", AttributeType.TOP));
        containerLayout.addConstraint("enable", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT));
        containerLayout.addConstraint("enable", AttributeType.RIGHT, (Constraint)new AttributeConstraint("_container", AttributeType.RIGHT));
        containerLayout.addConstraint("centerPanel", AttributeType.TOP, (Constraint)new AttributeConstraint("enable", AttributeType.BOTTOM, 10));
        containerLayout.addConstraint("centerPanel", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT));
        containerLayout.addConstraint("centerPanel", AttributeType.RIGHT, (Constraint)new AttributeConstraint("_container", AttributeType.RIGHT));
        containerLayout.addConstraint("expression", AttributeType.TOP, (Constraint)new AttributeConstraint("centerPanel", AttributeType.BOTTOM, 5));
        containerLayout.addConstraint("expression", AttributeType.LEFT, (Constraint)new AttributeConstraint("centerPanel", AttributeType.LEFT));
        containerLayout.addConstraint("expression", AttributeType.RIGHT, (Constraint)new AttributeConstraint("centerPanel", AttributeType.RIGHT));
    }

    private Panel createExpressionPanel(UiContainer parent) {
        LanguageSpec languageSpec;
        String language = EditorPreferences.getInstance().getLanguage();
        Panel scopeCondition = new Panel(parent, DesignerMsg.CONDITION);
        scopeCondition.setLayout((Layout)new BorderLayout());
        try {
            languageSpec = LanguageSpec.getLanguageSpec((String)language);
        }
        catch (InvalidLanguageException e) {
            MessageDialog.showError((Throwable)e);
            languageSpec = LanguageSpec.getSupportedLanguageSpecs()[0];
        }
        PlainEditor editor = new PlainEditor((UiContainer)scopeCondition, languageSpec);
        this.expressionPanel = editor;
        scopeCondition.add((UiComponent)editor, (Object)"Center");
        return scopeCondition;
    }

    private Panel createBeforeAfterPanel(UiContainer parent) {
        Panel result = new Panel(parent, ProjectModelMsg.BEFORE_AFTER);
        LabelMultiline text = new LabelMultiline((UiContainer)result, ((LoopFeature)this.getFeature()).getBeforeAfter().getDescription());
        this.beforeButton = new RadioButton((UiContainer)result, ProjectModelMsg.BEFORE);
        this.afterButton = new RadioButton((UiContainer)result, ProjectModelMsg.AFTER);
        ButtonGroup group = new ButtonGroup();
        group.add((AbstractButton)this.beforeButton);
        group.add((AbstractButton)this.afterButton);
        RelativeLayout layout = new RelativeLayout();
        result.setLayout((Layout)layout);
        result.add((UiComponent)text, (Object)"text");
        result.add((UiComponent)this.beforeButton, (Object)"before");
        result.add((UiComponent)this.afterButton, (Object)"after");
        layout.addConstraint("text", AttributeType.TOP, (Constraint)new AttributeConstraint("_container", AttributeType.TOP, 2));
        layout.addConstraint("text", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT, 2));
        layout.addConstraint("text", AttributeType.RIGHT, (Constraint)new AttributeConstraint("_container", AttributeType.RIGHT, -2));
        layout.addConstraint("before", AttributeType.TOP, (Constraint)new AttributeConstraint("text", AttributeType.BOTTOM, 10));
        layout.addConstraint("before", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT, 2));
        layout.addConstraint("after", AttributeType.TOP, (Constraint)new AttributeConstraint("before", AttributeType.TOP));
        layout.addConstraint("after", AttributeType.LEFT, (Constraint)new AttributeConstraint("before", AttributeType.RIGHT, 5));
        return result;
    }

    private void enableChanged() {
        boolean enabled = this.enableFeatureEditor.isSelected();
        this.beforeButton.setEnabled(enabled);
        this.afterButton.setEnabled(enabled);
        this.expressionPanel.setEnabled(enabled);
    }
}

