/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action.provider;

import java.util.LinkedList;
import java.util.List;
import oracle.bpm.adapter.Adaptable;
import oracle.bpm.collections.Function;
import oracle.bpm.command.Command;
import oracle.bpm.designer.ActionRunner;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesDialog;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesPreferences;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.extensionpoint.metadata.ActionGroupMetadata;
import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Gateway;
import oracle.bpm.project.model.processes.GatewayDirection;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.action.ActionGroupFactory;
import oracle.bpm.ui.action.BaseAction;
import org.jetbrains.annotations.NotNull;

@ActionGroupMetadata(target=Gateway.class)
public class GatewayChangeConfigurationActions
implements ActionGroupFactory {
    public ActionGroup create(Adaptable context) {
        Gateway gateway = context.as(Gateway.class);
        ActionGroup result = new ActionGroup();
        if (gateway.getMergingGateway() != null) {
            ActionGroup gateways = new ActionGroup(DesignerMsg.CHANGE_GATEWAY_CONFIGUTATION, new Class[]{Gateway.class});
            for (GatewayConfiguration configuration : this.resolveConfigutations(gateway)) {
                gateways.add((BaseAction)new ChangeGatewayConfigurationAction(configuration));
            }
            result.add((BaseAction)gateways);
        }
        return result;
    }

    private Iterable<GatewayConfiguration> resolveConfigutations(@NotNull Gateway gateway) {
        BpmnType affected = gateway.getBpmnType();
        BpmnType merging = gateway.getMergingGateway().getBpmnType();
        boolean diverging = gateway.getDirection() == GatewayDirection.DIVERGING;
        return GatewayConfiguration.from(diverging ? affected : merging, diverging ? merging : affected);
    }

    private static final class MutateGatewayFunction
    implements Function<FlowNode, FlowNode> {
        private final BpmnType type;

        public MutateGatewayFunction(@NotNull BpmnType type) {
            this.type = type;
        }

        @Override
        public FlowNode eval(@NotNull FlowNode value) {
            Gateway gateway = (Gateway)value.asAnyNode(Gateway.class);
            if (gateway != null) {
                ActionRunner.getInstance().run((Command)((Object)new ChangeGatewayTypeCommand(gateway, this.type)));
            }
            return gateway;
        }
    }

    public static final class ChangeGatewayTypeCommand
    extends ProjectCommand {
        private final Gateway gateway;
        private final BpmnType type;

        public ChangeGatewayTypeCommand(@NotNull Gateway gateway, @NotNull BpmnType type) {
            super(new ProjectObject[0]);
            this.gateway = gateway;
            this.type = type;
        }

        public String getName() {
            return this.type.getString();
        }

        public Object execute() throws ExecutionException {
            this.to(this.gateway, this.type);
            return null;
        }

        private void to(@NotNull Gateway gateway, @NotNull BpmnType type) {
            switch (type) {
                case COMPLEX_GATEWAY: {
                    gateway.toComplexGateway();
                    break;
                }
                case PARALLEL_GATEWAY: {
                    gateway.toParallel();
                    break;
                }
                case INCLUSIVE_GATEWAY: {
                    gateway.toInclusive();
                }
            }
        }
    }

    public static final class ChangeGatewayConfigurationAction
    extends DesignerAction {
        private GatewayConfiguration configuration;

        public ChangeGatewayConfigurationAction(@NotNull GatewayConfiguration configuration) {
            super(configuration.getMsg());
            this.requires(Gateway.class);
            this.configuration = configuration;
        }

        @Override
        public void run() {
            boolean isDiverging;
            FlowNodePropertiesPreferences preferences = FlowNodePropertiesPreferences.create();
            Gateway gateway = this.getGateway();
            boolean bl = isDiverging = gateway.getDirection() == GatewayDirection.DIVERGING;
            if (isDiverging && this.configuration.getDiverging() != gateway.getBpmnType() || !isDiverging && this.configuration.getConverging() != gateway.getBpmnType()) {
                preferences.addAfterCopyFunction(new MutateGatewayFunction(isDiverging ? this.configuration.getDiverging() : this.configuration.getConverging()));
            }
            preferences.setSelectedSheet(FlowNodePropertiesPreferences.SHOW_IMPLEMENTATION);
            if (FlowNodePropertiesDialog.editProperties((FlowNode)gateway, preferences)) {
                ChangeGatewayTypeCommand related = new ChangeGatewayTypeCommand(gateway.getMergingGateway(), isDiverging ? this.configuration.getConverging() : this.configuration.getDiverging());
                ActionRunner.getInstance().run((Command)((Object)related));
            }
        }

        private Gateway getGateway() {
            return (Gateway)this.getSelection().as(Gateway.class);
        }
    }

    private static enum GatewayConfiguration {
        PARALLEL_PARALLEL(DesignerMsg.PARALLEL_PARALLEL, BpmnType.PARALLEL_GATEWAY, BpmnType.PARALLEL_GATEWAY),
        PARALLEL_COMPLEX(DesignerMsg.PARALLEL_COMPLEX, BpmnType.PARALLEL_GATEWAY, BpmnType.COMPLEX_GATEWAY),
        INCLUSIVE_INCLUSIVE(DesignerMsg.INCLUSIVE_INCLUSIVE, BpmnType.INCLUSIVE_GATEWAY, BpmnType.INCLUSIVE_GATEWAY),
        INCLUSIVE_COMPLEX(DesignerMsg.INCLUSIVE_COMPLEX, BpmnType.INCLUSIVE_GATEWAY, BpmnType.COMPLEX_GATEWAY);

        private final Msg msg;
        private final BpmnType diverging;
        private final BpmnType converging;

        private GatewayConfiguration(Msg msg, BpmnType diverging, BpmnType converging) {
            this.msg = msg;
            this.diverging = diverging;
            this.converging = converging;
        }

        private Msg getMsg() {
            return this.msg;
        }

        private BpmnType getDiverging() {
            return this.diverging;
        }

        private BpmnType getConverging() {
            return this.converging;
        }

        private static List<GatewayConfiguration> from(BpmnType diverging, BpmnType converging) {
            LinkedList<GatewayConfiguration> result = new LinkedList<GatewayConfiguration>();
            for (GatewayConfiguration configuration : GatewayConfiguration.values()) {
                if (configuration.diverging == diverging && configuration.converging == converging) continue;
                result.add(configuration);
            }
            return result;
        }
    }
}

