/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action.provider;

import oracle.bpm.adapter.Adaptable;
import oracle.bpm.designer.measurementmark.DeleteCounterAction;
import oracle.bpm.designer.measurementmark.NewCounterAction;
import oracle.bpm.extensionpoint.metadata.ActionGroupMetadata;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.Counter;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.action.ActionGroupFactory;
import oracle.bpm.ui.action.BaseAction;

@ActionGroupMetadata(target=Activity.class)
public class CountersActions
implements ActionGroupFactory {
    public ActionGroup create(Adaptable context) {
        ActionGroup actionGroup = new ActionGroup();
        Activity activity = context.as(Activity.class);
        Counter counter = ModelUtils.findCounterByActivity((Process)activity.getProcess(), (Activity)activity);
        if (counter != null) {
            actionGroup.add((BaseAction)new DeleteCounterAction(counter));
        } else {
            actionGroup.add((BaseAction)new NewCounterAction(activity));
        }
        return actionGroup;
    }

    private boolean hasCounter(Activity activity) {
        for (Counter counter : activity.getProcess().getCounters()) {
            Activity associated = counter.getActivity();
            if (associated == null || !associated.equals(activity)) continue;
            return true;
        }
        return false;
    }
}

