/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action.provider;

import oracle.bpm.adapter.Adaptable;
import oracle.bpm.designer.activityguide.AddMilestoneActivityToMilestoneAction;
import oracle.bpm.designer.activityguide.MoveMilestoneActivityToMilestoneAction;
import oracle.bpm.extensionpoint.metadata.ActionGroupMetadata;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.activityguide.Milestone;
import oracle.bpm.project.model.activityguide.MilestoneActivity;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.action.ActionGroupFactory;
import oracle.bpm.ui.action.BaseAction;
import org.jetbrains.annotations.NotNull;

@ActionGroupMetadata(target=Activity.class)
public class ActivityMilestoneActions
implements ActionGroupFactory {
    public ActionGroup create(Adaptable context) {
        Activity activity = context.as(Activity.class);
        ActionGroup result = new ActionGroup();
        Project project = activity.getProject();
        if (project != null && activity.isUserTask() && project.getCase() == null) {
            result = new ActionGroup();
            MilestoneActivity milestonActivity = this.getMilestoneActivity((FlowNode)activity);
            if (milestonActivity != null) {
                result.add((BaseAction)new MoveMilestoneActivityToMilestoneAction(milestonActivity));
            } else {
                result.add((BaseAction)new AddMilestoneActivityToMilestoneAction(project.getActivityGuide()));
            }
        }
        return result;
    }

    private MilestoneActivity getMilestoneActivity(@NotNull FlowNode flowNode) {
        for (Milestone milestone : flowNode.getProject().getActivityGuide().getChildrenByType(Milestone.class)) {
            for (MilestoneActivity milestoneActivity : milestone.getChildrenByType(MilestoneActivity.class)) {
                if (milestoneActivity.getActivity() != flowNode) continue;
                return milestoneActivity;
            }
        }
        return null;
    }
}

