/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action.organization;

import java.io.File;
import oracle.bpm.project.io.fs.FileProjectWriter;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.ProjectWriter;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.filechooser.FileChooser;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.util.FileFilter;

public abstract class AbstractOrganizationAction
extends BaseAction {
    private Organization organization;
    private ProjectWriter projectWriter;

    public AbstractOrganizationAction(Msg msg, Organization organization) {
        super(msg);
        this.organization = organization;
        this.projectWriter = this.getOrganization().getProject().getWriter();
    }

    public Organization getOrganization() {
        return this.organization;
    }

    protected FileChooser getFileChooser() {
        FileChooser chooser = new FileChooser();
        chooser.setName("organization.chooser");
        FileProjectWriter projectWriter = (FileProjectWriter)this.projectWriter;
        chooser.setDefaultDirectory(projectWriter.getProjectFileSystem().getLocalFileSystem().getRootFolder());
        String fileName = this.getOrganization().getProject().getName();
        chooser.setSelectedFile(new File(chooser.getCurrentDirectory().getPath() + File.separator + fileName + ".xdml"));
        FileFilter filter = FileFilter.create(UIMsg.XDML, ".xdml", ".xml");
        chooser.setAcceptAllFileFilterUsed(true);
        chooser.setFileFilter(filter);
        return chooser;
    }
}

