/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectPreferences;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.ui.CustomFuegoAction;

public class TemplateToProjectAction
extends CustomFuegoAction {
    public TemplateToProjectAction() {
        super(DesignerMsg.CONVERT_TO_PROJECT);
        this.requires(Project.class);
    }

    public void run() {
        this.convert();
    }

    private void convert() {
        Project project = (Project)this.getSelection().as(Project.class);
        assert (project.isTemplate()) : "project already a regular project";
        ProjectPreferences preferences = project.getPreferences();
        preferences.setTemplate(false);
        try {
            project.getWriter().write(new ProjectObject[]{preferences});
        }
        catch (ProjectException e) {
            throw new RuntimeException(e);
        }
    }
}

