/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.command.Command;
import oracle.bpm.designer.ActionRunner;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.project.command.design.SwitchDraftMarkCommand;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Draftable;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.msg.UIMsg;
import org.jetbrains.annotations.NotNull;

public class SwitchDraftMarkAction
extends DesignerAction {
    private Draftable draftable;

    public SwitchDraftMarkAction(@NotNull Draftable draftable) {
        super(draftable.isDraft() ? DesignerMsg.UNMARK_DRAFT : DesignerMsg.MARK_DRAFT);
        this.setSmallIcon(Image.create((Msg)UIMsg.DRAFT));
        this.requires(Draftable.class);
        this.draftable = draftable;
    }

    @Override
    public void run() {
        try {
            ActionRunner.getInstance().run((Command)new SwitchDraftMarkCommand(this.draftable));
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ProjectException) {
                MessageDialog.showError((Msg)((ProjectException)e.getCause()).getMsg());
            }
            throw e;
        }
    }
}

