/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.TypesFilter;
import oracle.bpm.designer.action.OpenComponentAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Point;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.type.AmbiguousTypeNameException;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.TypeUtils;
import oracle.bpm.ui.CloseableDialog;
import oracle.bpm.ui.Frame;
import oracle.bpm.ui.ListSelectionMode;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.SeparatorPanel;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.KeyEvent;
import oracle.bpm.ui.event.ListSelectionEvent;
import oracle.bpm.ui.event.ListSelectionListener;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.table.AbstractTableModel;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.table.TableAdapter;
import oracle.bpm.ui.table.TableListener;
import oracle.bpm.ui.table.TableModel;
import oracle.bpm.ui.table.ViewerSorter;
import oracle.bpm.ui.text.TextArea;

public class ShowComponentIndexAction
extends DesignerAction {
    private TextArea descriptionTextArea;
    private ComponentIndexPreferences preferences;
    private Table table;
    private static final int CATEGORY = 0;
    private static final int NAME = 1;
    private static final int DESCRIPTION = 2;

    public ShowComponentIndexAction() {
        super(DesignerMsg.COMPONENT_INDEX);
    }

    @Override
    public boolean doIt() {
        this.showDialog();
        return true;
    }

    public void unDoIt() {
    }

    private void init(UiContainer parent) {
        final ComponentIndexTableModel tableModel = new ComponentIndexTableModel();
        this.table = new Table(parent, (TableModel)tableModel, ListSelectionMode.SINGLE_SELECTION);
        this.table.setSorter(new ViewerSorter());
        this.table.addTableListener((TableListener)new ComponentIndexTableListener(tableModel));
        this.descriptionTextArea = new TextArea(parent);
        this.descriptionTextArea.setRows(4);
        this.descriptionTextArea.setColumns(10);
        this.descriptionTextArea.setEditable(false);
        this.descriptionTextArea.setLineWrap(true);
        this.descriptionTextArea.setWrapStyleWord(true);
        this.table.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int index = ShowComponentIndexAction.this.table.getSelectedRow();
                String text = "";
                if (index >= 0) {
                    ComponentIndexEntry entry = tableModel.getEntrytAt(index);
                    text = entry.getDescription();
                }
                ShowComponentIndexAction.this.descriptionTextArea.setText(text);
            }
        });
    }

    private void layout(Panel panel) {
        String rows = "5dlu, fill:pref:grow, 5dlu, pref, 2dlu, pref, 5dlu";
        String columns = "5dlu, fill:pref:grow, 5dlu";
        FormLayout layout = new FormLayout(columns, rows);
        PanelBuilder builder = layout.createBuilder(panel);
        CellConstraints cc = layout.createCellConstraints();
        builder.add((UiComponent)this.table, cc.xy(2, 2));
        builder.add((UiComponent)new SeparatorPanel((UiContainer)panel, DesignerMsg.DETAILS), cc.xy(2, 4));
        builder.add((UiComponent)this.descriptionTextArea, cc.xy(2, 6));
    }

    private void loadPreferences(CloseableDialog dialog) {
        if (this.preferences != null) {
            dialog.setSize(this.preferences.getDialogSize());
            dialog.setLocation(this.preferences.getDialogLocation());
            int[] sizes = this.preferences.getColumnSizes();
            for (int i = 0; i < sizes.length; ++i) {
                this.table.getColumn(i).setWidth(sizes[i]);
            }
        }
    }

    private void showComponent(CloseableDialog dialog) {
        if (this.preferences == null) {
            dialog.pack();
            dialog.setLocationRelativeTo((UiComponent)((Frame)null));
        } else {
            this.loadPreferences(dialog);
        }
        dialog.setVisible(true);
    }

    private void showDialog() {
        CloseableDialog dialog = new CloseableDialog(Ui.getRoot(), DesignerMsg.COMPONENT_INDEX, true){

            public void ok() {
                this.close();
            }

            public void close() {
                ShowComponentIndexAction.this.storePreferences(this);
                super.close();
            }
        };
        Panel panel = new Panel((UiContainer)dialog);
        this.init((UiContainer)panel);
        this.layout(panel);
        dialog.getContentPane().add((UiComponent)panel, (Object)"Center");
        this.showComponent(dialog);
    }

    private void storePreferences(CloseableDialog dialog) {
        if (this.preferences == null) {
            this.preferences = new ComponentIndexPreferences();
        }
        this.preferences.setDialogSize(dialog.getSize());
        this.preferences.setDialogLocation(dialog.getLocation());
        int count = this.table.getColumnCount();
        int[] sizes = new int[count];
        for (int i = 0; i < count; ++i) {
            sizes[i] = this.table.getColumn(i).getWidth();
            sizes[i] = this.table.getColumn(i).getWidth();
        }
        this.preferences.setColumnSizes(sizes);
    }

    private static class ComponentIndexTableModel
    extends AbstractTableModel {
        public List<ComponentIndexEntry> allComponents;
        private TypesFilter typesFilter = new TypesFilter(1314431);

        public ComponentIndexTableModel() {
            this.allComponents = this.getAllFuegoBlockComponents();
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return UIMsg.CATEGORY.toString();
                }
                case 1: {
                    return ProjectDrawMsg.NAME.toString();
                }
                case 2: {
                    return DesignerMsg.DESCRIPTION.toString();
                }
            }
            return null;
        }

        public ComponentIndexEntry getEntrytAt(int row) {
            return this.allComponents.get(row);
        }

        public int getRowCount() {
            return this.allComponents.size();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            ComponentIndexEntry object = this.getEntrytAt(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return object.getCategory();
                }
                case 1: {
                    return object.getName();
                }
                case 2: {
                    return object.getDescription();
                }
            }
            return null;
        }

        private List<ComponentIndexEntry> getAllFuegoBlockComponents() {
            ArrayList<ComponentIndexEntry> list = new ArrayList<ComponentIndexEntry>();
            try {
                TypeRef fuegoRoot = TypeUtils.getDefaultCatalog().find("Fuego");
                ObjectTypeDescription rootObject = (ObjectTypeDescription)fuegoRoot.get();
                int count = rootObject.getInnerTypeCount();
                for (int i = 0; i < count; ++i) {
                    ObjectTypeDescription eachModule = rootObject.getInnerType(i);
                    String module = eachModule.getName();
                    if (!this.typesFilter.isValid(eachModule)) continue;
                    int innerCount = eachModule.getInnerTypeCount();
                    for (int j = 0; j < innerCount; ++j) {
                        TypeRef childRef = eachModule.getInnerTypeRef(j);
                        if (!this.typesFilter.isValid(childRef)) continue;
                        list.add(new ComponentIndexEntry(childRef, module));
                    }
                }
            }
            catch (AmbiguousTypeNameException ambiguousTypeNameException) {
                // empty catch block
            }
            return list;
        }
    }

    private static class ComponentIndexTableListener
    extends TableAdapter {
        private ComponentIndexTableModel model;

        public ComponentIndexTableListener(ComponentIndexTableModel model) {
            this.model = model;
        }

        public void doubleClick(Table table, int row, int column, MouseEvent e) {
            this.open(row);
        }

        public boolean keyPressed(Table table, int row, KeyEvent e) {
            if (e.isEnter()) {
                this.open(row);
            }
            return false;
        }

        private void open(int row) {
            TypeRef object = this.model.getEntrytAt(row).getTypeRef();
            if (object != null) {
                new OpenComponentAction((ObjectTypeDescription)object.get()).run();
            }
        }
    }

    private static class ComponentIndexPreferences {
        private int[] columnSizes;
        private Point dialogLocation;
        private Dimension dialogSize;

        private ComponentIndexPreferences() {
        }

        public void setColumnSizes(int[] columnSizes) {
            this.columnSizes = columnSizes;
        }

        public int[] getColumnSizes() {
            return this.columnSizes;
        }

        public void setDialogLocation(Point dialogLocation) {
            this.dialogLocation = dialogLocation;
        }

        public Point getDialogLocation() {
            return this.dialogLocation;
        }

        public void setDialogSize(Dimension dialogSize) {
            this.dialogSize = dialogSize;
        }

        public Dimension getDialogSize() {
            return this.dialogSize;
        }

        public String toString() {
            return "----Preferences: dialogSize = " + this.dialogSize + " dialogLocation = " + this.dialogLocation + " columnSizes = " + this.columnSizes;
        }
    }

    private static class ComponentIndexEntry {
        private String module;
        private TypeRef object;

        public ComponentIndexEntry(TypeRef typeRef, String module) {
            this.module = module;
            this.object = typeRef;
        }

        public String getCategory() {
            return this.module;
        }

        public String getDescription() {
            return ((ObjectTypeDescription)this.object.get()).getDescription();
        }

        public String getName() {
            return this.object.getName();
        }

        public TypeRef getTypeRef() {
            return this.object;
        }
    }
}

