/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.action.BPMObjectAttributeInputValidator;
import oracle.bpm.designer.action.BPMObjectMethodInputValidator;
import oracle.bpm.designer.action.FuegoObjectAction;
import oracle.bpm.designer.action.NewMethodAction;
import oracle.bpm.designer.action.OpenCloseMemberAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.lang.InputValidationException;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.DialogFactory;
import oracle.bpm.ui.HiddenMessagesPreferences;
import oracle.bpm.ui.InputValidator;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;

public class RenameMemberAction
extends DesignerAction {
    private CatalogMember member;
    private String name;
    private String newName;

    public RenameMemberAction(CatalogMember selectedNode, String newName) {
        super(DesignerMsg.RENAME);
        this.requires(CatalogMember.class);
        this.member = selectedNode;
        this.newName = newName;
    }

    public void setGroupAttribute(boolean groupAttribute) {
    }

    @Override
    public boolean doIt() {
        boolean isNewName = !this.member.getName().equals(this.newName);
        return isNewName && this.rename();
    }

    public boolean rename() {
        boolean result;
        CatalogObject parent = this.member.getParentObject();
        if (this.member.getMemberType().isConstructor()) {
            result = this.showConstructorConfirmationDialog();
            if (result) {
                // empty if block
            }
        } else {
            result = this.getAValidName(parent);
            if (result) {
                this.rename(parent, this.member);
            }
        }
        return result;
    }

    public void rename(CatalogObject parent, CatalogMember member) {
        OpenCloseMemberAction.closeMember(member.getMemberType());
        this.renameReferences(parent);
        parent.getObjectType().renameMember(member.getMemberType(), this.name);
        CatalogObject catalogObject = CatalogObjectImpl.create((TypeRef)parent.getObjectType());
        FuegoObjectAction.storeObjectIfEditorIsNotActive(catalogObject);
    }

    public void unDoIt() {
    }

    private boolean getAValidName(CatalogObject parent) {
        this.name = this.newName;
        boolean result = this.name == null ? this.promptForNewName(this.member) : this.validateName(parent);
        if (result) {
            NewMethodAction.AccessorValidator av = new NewMethodAction.AccessorValidator(this.name, parent.getObjectType());
            if (av.isAccessor()) {
                int answer = MessageDialog.showQuestion((UiContainer)Ui.getRoot(), (Msg)DesignerMsg.ADD_METHOD, (Msg)av.getMsg(), null, (int)0, null);
                if (answer == 1 || answer == 2) {
                    return av.executeEditAccessor();
                }
                if (answer == 8) {
                    return false;
                }
            }
            result = this.showMemberConfirmationDialog(this.member);
        }
        return result;
    }

    private boolean closeEditors() {
        return true;
    }

    private boolean promptForNewName(CatalogMember member) {
        this.name = member.isAttribute() ? MessageDialog.showInputDialog((UiWindow)Ui.getRoot(), (Msg)DesignerMsg.NEW_NAME, (Msg)DesignerMsg.RENAME, (InputValidator)new BPMObjectAttributeInputValidator(member.getParentObject()), (String)member.getName(), (int)256) : MessageDialog.showInput((UiWindow)Ui.getRoot(), (Msg)DesignerMsg.NEW_NAME, (Msg)DesignerMsg.RENAME, (String)member.getName(), (InputValidator)new BPMObjectMethodInputValidator(member.getParentObject()));
        return this.name != null;
    }

    private boolean renameReferences(CatalogObject parent) {
        boolean result = this.closeEditors();
        if (result && this.member.isAttribute()) {
            this.renameValidValuesInvocation(parent);
        }
        return result;
    }

    private void renameValidValuesInvocation(CatalogObject parent) {
        ObjectTypeDescription parentOtd = parent.getObjectType();
        MethodTypeDescription mtd = parentOtd.findMethod(this.member.getName() + "ValidValues");
        if (mtd != null) {
            parentOtd.renameMember(mtd, this.name + "ValidValues");
        }
    }

    private boolean showMemberConfirmationDialog(CatalogMember method) {
        return DialogFactory.showConfirmDialog((HiddenMessagesPreferences)DesignerPreferences.getPreferences(), (Msg)DesignerMsg.RENAME, (Msg)(method.isAttribute() ? DesignerMsg.CONFIRM_RENAME_ATTRIBUTE : DesignerMsg.CONFIRM_RENAME_METHOD));
    }

    private boolean showConstructorConfirmationDialog() {
        String xoName = this.member.getParentObject().getName();
        return DialogFactory.showConfirmDialog((Msg)DesignerMsg.RENAME, (Msg)DesignerMsg.CONFIRM_RENAME_CONSTRUCTOR(xoName));
    }

    private boolean validateName(CatalogObject parent) {
        boolean result = false;
        if (this.member.isAttribute()) {
            try {
                new BPMObjectAttributeInputValidator(parent).validate(this.name);
                result = true;
            }
            catch (InputValidationException e) {
                MessageDialog.showError((Msg)DesignerMsg.ATTRIBUTE_NAME, (Msg)e.getKey());
                return false;
            }
        }
        if (this.member.isMethod()) {
            try {
                new BPMObjectMethodInputValidator(parent).validate(this.name);
                result = true;
            }
            catch (InputValidationException e) {
                MessageDialog.showError((Msg)DesignerMsg.WRONGNAME, (Msg)e.getKey());
                return false;
            }
        }
        return result;
    }
}

