/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import java.util.Collection;
import oracle.bpm.command.Command;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.command.RemoveObjectsCommand;
import oracle.bpm.project.importer.CancelActionException;
import oracle.bpm.project.ui.ModelObjectSelection;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.selection.Selection;

public class RemoveObjectsAction
extends DesignerAction {
    private static RemoveObjectsAction instance;

    public RemoveObjectsAction() {
        super(UIMsg.MENU_DELETE);
        this.requires(ModelObjectSelection.class);
    }

    public static RemoveObjectsAction getInstance() {
        if (instance == null) {
            instance = new RemoveObjectsAction();
        }
        return instance;
    }

    @Override
    public void run() throws CancelActionException {
        Selection selection = this.getSelection();
        if (selection != null) {
            try {
                ModelObjectSelection modelObjects = (ModelObjectSelection)selection.as(ModelObjectSelection.class);
                Collection flowElements = modelObjects.normalizeForRemove();
                this.getRunner().run((Command)((Object)new RemoveObjectsCommand(flowElements)));
            }
            catch (Exception e) {
                MessageDialog.showError((Msg)Msg.QUOTE(e.getMessage()));
            }
        }
    }
}

