/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.action.FuegoObjectAction;
import oracle.bpm.designer.action.OpenCloseMemberAction;
import oracle.bpm.designer.action.RemoveComponentMemberAction;
import oracle.bpm.designer.catalog.tree.ObjectMethodMemberTreeNode;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.resources.BoolMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.xobject.lib.ConstructionException;
import oracle.bpm.xobject.lib.XObjectTypeDescriptionHelper;
import oracle.bpm.xobject.presentationmodel.XFormPresentationModel;

public class RemoveComponentMethodAction
extends RemoveComponentMemberAction {
    private MethodTypeDescription method = null;

    public RemoveComponentMethodAction(ObjectMethodMemberTreeNode node) {
        super(UIMsg.MENU_DELETE);
        this.method = node.getMember();
        this.requires(MethodTypeDescription.class);
    }

    @Override
    public boolean doIt() {
        boolean result = false;
        if (this.method.getParent() instanceof XObjectTypeDescription) {
            boolean removeReferences = false;
            XObjectTypeDescription parent = (XObjectTypeDescription)this.method.getParent();
            XFormPresentationModel[] referencedPresentations = RemoveComponentMethodAction.getReferencedPresentations(parent, this.method);
            if (referencedPresentations != null) {
                BoolMsg removePresentationReferences = new BoolMsg(true, DesignerMsg.REMOVED_REFERENCES);
                int option = MessageDialog.showQuestion((UiContainer)Ui.getRoot(), (Msg)DesignerMsg.REMOVE, (Msg)DesignerMsg.REMOVE_MEMBER_CONFIRM(this.method.getName()), null, (int)6, (BoolMsg)removePresentationReferences);
                result = option == 2;
                removeReferences = removePresentationReferences.get();
                if (result && removeReferences) {
                    RemoveComponentMethodAction.closeReferencedPresentations(this.method);
                }
            } else {
                result = this.confirmDeleteMethod();
            }
            if (result) {
                this.closeEditor();
                result = this.removeMember(parent, this.method.getName(), removeReferences);
                CatalogObject catalogObject = CatalogObjectImpl.create((TypeRef)parent);
                FuegoObjectAction.storeObjectIfEditorIsNotActive(catalogObject);
            }
        }
        return result;
    }

    public void unDoIt() {
    }

    @Override
    protected void closeEditor() {
        OpenCloseMemberAction.closeMember(this.method);
    }

    private boolean confirmDeleteMethod() {
        DesignerPreferences preferences = DesignerPreferences.getPreferences();
        if (preferences.getShowConfirmWhenDeletingCil()) {
            BoolMsg msg = new BoolMsg(false, CoreMsg.DO_NOT_SHOW_THIS_MESSAGE);
            int value = MessageDialog.showQuestion((UiContainer)null, (Msg)CoreMsg.WARNING, (Msg)DesignerMsg.CONFIRM_CIL_DELETE, null, (int)6, (BoolMsg)msg);
            preferences.setShowConfirmWhenDeletingCil(!msg.value);
            if (value != 2) {
                return false;
            }
        }
        return true;
    }

    private boolean removeMember(XObjectTypeDescription parent, String name, boolean removeReferences) {
        boolean result = true;
        try {
            XObjectTypeDescriptionHelper.removeMember((ObjectTypeDescription)parent, (String)name, (boolean)removeReferences);
        }
        catch (ConstructionException e) {
            MessageDialog.showError((Msg)DesignerMsg.REMOVEBRK, (Throwable)e);
            result = false;
        }
        return result;
    }
}

