/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.Transactable;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.ui.ActionOrder;

public class ReloadCatalogAction
extends DesignerAction {
    private CatalogObject catalogObject;
    private static Reloader reloader;

    public ReloadCatalogAction(CatalogObject catalogObject) {
        super(DesignerMsg.RELOAD);
        this.catalogObject = catalogObject;
        this.requires(ObjectTypeDescription.class);
        this.requires(CatalogObject.class);
        this.setOrder(ActionOrder.BOTTOM);
        this.setShowOnDisabled(false);
    }

    public static Reloader getReloader() {
        return reloader;
    }

    public static void setReloader(Reloader reloader) {
        ReloadCatalogAction.reloader = reloader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doIt() {
        Project project = this.catalogObject.getProject();
        Transactable root = (Transactable)project.getCatalogRoot();
        try {
            root.beginTransaction();
            MutableComponentCatalog catalog = (MutableComponentCatalog)project.getComponentCatalog();
            catalog.sync();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            root.endTransaction();
        }
        return true;
    }

    public static interface Reloader {
        public void reload();
    }
}

