/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.Context;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.SwingWorker;

public class RefreshCatalogAction
extends DesignerAction {
    public RefreshCatalogAction() {
        super(DesignerMsg.REFRESH_CATALOG_NODE);
    }

    @Override
    public boolean doIt() {
        return this.refresh();
    }

    public void unDoIt() {
    }

    private boolean refresh() {
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                try {
                    Project project = Context.getProject();
                    project.getRepository().refresh(project);
                }
                catch (ProjectException e) {
                    return e;
                }
                return Boolean.TRUE;
            }

            public void finished() {
                if (this.getValue() instanceof Throwable) {
                    MessageDialog.showError((Throwable)((Throwable)this.getValue()));
                }
            }
        };
        worker.start();
        return true;
    }
}

