/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectPreferences;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CustomFuegoAction;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiContainer;

public class ProjectToTemplateAction
extends CustomFuegoAction {
    public ProjectToTemplateAction() {
        super(DesignerMsg.CONVERT_TO_TEMPLATE);
        this.requires(Project.class);
    }

    public void run() {
        this.convert();
    }

    public boolean showsDialog() {
        return true;
    }

    private void convert() {
        Project project = (Project)this.getSelection().as(Project.class);
        int result = MessageDialog.showQuestion((UiContainer)Ui.getRoot(), (Msg)DesignerMsg.CONVERT_TO_TEMPLATE, (Msg)DesignerMsg.CONVERT_TO_TEMPLATE_CONFIRMATION, null, (int)0x1000006, null);
        if (result == 2) {
            assert (!project.isTemplate()) : "project already a template";
            ProjectPreferences preferences = project.getPreferences();
            preferences.setTemplate(true);
            preferences.setTemplateName(project.getName());
            try {
                project.getWriter().write(new ProjectObject[]{preferences});
            }
            catch (ProjectException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

