/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import java.util.Locale;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.ProcessEditor;
import oracle.bpm.designer.ProcessPanel;
import oracle.bpm.designer.ProjectPreferencesDialog;
import oracle.bpm.designer.StudioWorkbench;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.Any;
import oracle.bpm.project.FuegoProject;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectPreferences;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.ui.CustomFuegoAction;
import oracle.bpm.ui.Ui;

public class ProjectPreferencesAction
extends CustomFuegoAction {
    public ProjectPreferencesAction() {
        super(DesignerMsg.PROJECT_PREFERENCES);
        this.requires(FuegoProject.class);
    }

    public void run() {
        this.doIt();
    }

    private boolean doIt() {
        Project project = (Project)this.getSelection().as(Project.class);
        if (!project.isOpen()) {
            return false;
        }
        ProjectPreferences preferences = project.getPreferences();
        Locale defaultLanguage = preferences.getDefaultLanguage();
        ProjectPreferencesDialog dialog = new ProjectPreferencesDialog(Ui.getRoot(), project);
        dialog.setVisible(true);
        boolean userAccepted = dialog.userAccepted();
        if (userAccepted && !Any.equals(defaultLanguage, preferences.getDefaultLanguage())) {
            StudioWorkbench workbench = AbstractStudioWorkbench.getInstance();
            Sequence<ProcessEditor> editors = AbstractStudioWorkbench.getInstance().getEditorsByClass(ProcessEditor.class);
            for (ProcessEditor editor : editors) {
                ProcessPanel panel = editor.getProcessPanel();
                Process content = panel.getModel();
                panel.repaint();
                panel.setPanelId(content.getId());
                workbench.refreshTitle(editor);
            }
        }
        return userAccepted;
    }
}

