/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.StudioWorkbench;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.RepositoryAdapter;
import oracle.bpm.project.model.RepositoryService;
import oracle.bpm.project.model.events.RepositoryListener;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.selection.Selection;

public class ProjectBusinessRulesAction
extends BaseAction {
    public ProjectBusinessRulesAction() {
        super(ProjectMsg.BUSINESS_RULES);
        this.requires(ProjectObject.class);
        RepositoryService.getInstance().getActiveRepository().addRepositoryListener((RepositoryListener)new RepositoryAdapter(){

            public void projectClosed(Project project) {
                ProjectBusinessRulesAction.this.updateEnableStatus(ProjectBusinessRulesAction.this.getSelection());
            }
        });
    }

    public void run() {
        Project project;
        Selection selection = this.getSelection();
        ProjectObject projectObject = (ProjectObject)selection.as(ProjectObject.class);
        if (projectObject != null && (project = projectObject.getProject()).isOpen()) {
            StudioWorkbench workbench = AbstractStudioWorkbench.getInstance();
            workbench.openEditorForObject(project.getProjectModel());
        }
    }

    protected void updateEnableStatus(Selection selection) {
        ProjectObject projectObject = (ProjectObject)selection.as(ProjectObject.class);
        this.setEnabled(projectObject != null && projectObject.getProject().isOpen());
    }
}

