/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import java.util.Iterator;
import oracle.bpm.designer.Clipboard;
import oracle.bpm.designer.ProcessDomain;
import oracle.bpm.designer.ProcessUsagesAction;
import oracle.bpm.designer.action.AddFlowNodesActionGroup;
import oracle.bpm.designer.action.DesignerCopyAction;
import oracle.bpm.designer.action.DesignerCutAction;
import oracle.bpm.designer.action.DesignerPasteAction;
import oracle.bpm.designer.action.GenerateProcessImageAction;
import oracle.bpm.designer.action.InsertLaneAction;
import oracle.bpm.designer.action.ProcessPropertiesAction;
import oracle.bpm.designer.controller.ActivityController;
import oracle.bpm.designer.controller.FlowElementController;
import oracle.bpm.designer.controller.LaneController;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.selection.DesignerSelection;
import oracle.bpm.geom.Point;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.action.BaseAction;
import org.jetbrains.annotations.NotNull;

public class ProcessCanvasActions {
    private ProcessDomain domain;
    private final Point location;

    public ProcessCanvasActions(@NotNull ProcessDomain domain, @NotNull Point location) {
        this.domain = domain;
        this.location = location;
    }

    public static BaseAction createNewLaneAction(@NotNull Process model, @NotNull Point location) {
        return new InnerAddLaneAction(model, location);
    }

    public ActionGroup buildActions() {
        ActionGroup mainAction = new ActionGroup(DesignerMsg.ALL);
        mainAction.add((BaseAction)ProcessPropertiesAction.getInstance());
        mainAction.add(ProcessCanvasActions.createNewLaneAction(this.getProcess(), this.location));
        mainAction.add((BaseAction)new AddFlowNodesActionGroup((NodeContainer)this.getProcess(), DesignerMsg.ADD_ACTIVITY, this.location, this.getProcessDomain().getCanvas()));
        mainAction.add((BaseAction)new ProcessUsagesAction());
        DesignerSelection selection = this.getProcessDomain().getSelectionProvider().getSelection();
        if (!selection.isEmpty()) {
            mainAction.add((BaseAction)DesignerCutAction.getInstance());
        }
        if (!selection.isEmpty()) {
            Iterator iterator = selection.iterator();
            boolean foundOne = false;
            while (iterator.hasNext()) {
                FlowElementController controller = (FlowElementController)iterator.next();
                if (!(controller instanceof LaneController) && !(controller instanceof ActivityController)) continue;
                foundOne = true;
                break;
            }
            if (foundOne) {
                mainAction.add((BaseAction)DesignerCopyAction.getInstance());
            }
        }
        if (Clipboard.getInstance().canPaste()) {
            DesignerPasteAction action = DesignerPasteAction.getInstance();
            action.setTargetLocation(this.location);
            mainAction.add((BaseAction)action);
        }
        mainAction.add((BaseAction)GenerateProcessImageAction.getInstance());
        return mainAction;
    }

    public ProcessDomain getProcessDomain() {
        return this.domain;
    }

    private Process getProcess() {
        return this.getProcessDomain().getDomainElement();
    }

    static class InnerAddLaneAction
    extends BaseAction {
        private final Point location;
        private final Process model;

        public InnerAddLaneAction(@NotNull Process model, @NotNull Point location) {
            super(DesignerMsg.ADD_ROLE);
            this.model = model;
            this.requires(Process.class);
            this.location = location;
        }

        public void run() {
            InsertLaneAction.createInsertRoleAction(this.model, this.location).run();
        }
    }
}

