/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.InputValidationException;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.ui.FuegoWorker;
import oracle.bpm.ui.InputValidatorImpl;

public class PresentationNameValidator
extends InputValidatorImpl {
    private XObjectTypeDescription xobject;

    public PresentationNameValidator(XObjectTypeDescription xobject) {
        this.xobject = xobject;
    }

    public void validate(String name) throws InputValidationException {
        char firstChar;
        if (name == null) {
            return;
        }
        if (name.length() > 0 && PresentationNameValidator.isUpperCaseValidationEnabled((char)(firstChar = name.charAt(0)))) {
            InputValidationException.assertTrue(Character.isUpperCase(firstChar), DesignerMsg.NAME_SHOULD_START_IN_UPPER);
        }
        InputValidationException.assertNotEmpty(name, DesignerMsg.PRESENTATION_NAME_CANNOT_BE_EMPTY);
        this.validateNameExistance(name);
    }

    private void validateNameExistance(final String name) throws InputValidationException {
        boolean nameExists = FuegoWorker.post((FuegoWorker.BooleanJob)new FuegoWorker.BooleanJob(){

            public boolean run() {
                return PresentationNameValidator.this.xobject.getPresentations().containsKey(name);
            }
        });
        InputValidationException.assertFalse(nameExists, DesignerMsg.PRESENTATION_NAME_ALREADY_EXISTS(name));
    }
}

