/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.ProjectNavigatorTree;
import oracle.bpm.designer.ProjectObjectTreeNode;
import oracle.bpm.designer.catalog.tree.ObjectMemberTreeNode;
import oracle.bpm.designer.process.tree.DesignerProcessTreeNode;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.tree.TreeNode;
import oracle.bpm.ui.tree.TreePath;

public abstract class PathAction
extends DesignerAction {
    public static String MSG_ID = "MSG_ID";
    public static String NAME_ID = "NAME_ID";
    public static String PROCESS_ID = "PROCESS_ID";
    public static String MEMBER_ID = "MEMBER_ID";
    private static TreeNode.Matcher nodeMatcher;

    private PathAction(Msg msg) {
        super(msg);
    }

    public static TreeNode find(TreeNode root, String[] path) {
        return root.findPath(path, PathAction.getMatcher());
    }

    public static String[] obtainNamePath(TreePath path) {
        if (path != null) {
            Object[] o = path.getPath();
            String[] pathName = new String[o.length];
            for (int i = 0; i < o.length; ++i) {
                pathName[i] = o[i] instanceof TreeNode ? PathAction.getIDString((TreeNode)o[i]) : o[i].toString();
            }
            return pathName;
        }
        return null;
    }

    public TreeNode findProject(String[] path) {
        ProjectNavigatorTree projectTree = AbstractStudioWorkbench.getInstance().getProjectTree();
        ProjectObjectTreeNode root = projectTree.getRoot();
        return PathAction.find(root, path);
    }

    private static String getIDString(TreeNode node) {
        if (node.getMsg() != null) {
            return MSG_ID + node.getMsg().getCode();
        }
        if (node instanceof DesignerProcessTreeNode) {
            DesignerProcessTreeNode processNode = (DesignerProcessTreeNode)node;
            return PROCESS_ID + processNode.getProcessName();
        }
        if (node instanceof ObjectMemberTreeNode) {
            ObjectMemberTreeNode memberNode = (ObjectMemberTreeNode)node;
            return MEMBER_ID + memberNode.getName();
        }
        return NAME_ID + node.toString();
    }

    private static TreeNode.Matcher getMatcher() {
        if (nodeMatcher == null) {
            nodeMatcher = new TreeNode.Matcher(){

                public boolean match(String id, TreeNode node) {
                    Msg nodeMsg;
                    boolean result = id == null ? node == null : (node == null ? false : (id.startsWith(MSG_ID) ? (nodeMsg = node.getMsg()) != null && id.substring(MSG_ID.length()).equals(nodeMsg.getCode()) : (id.startsWith(PROCESS_ID) ? node instanceof DesignerProcessTreeNode && id.substring(PROCESS_ID.length()).equals(((DesignerProcessTreeNode)node).getProcessName()) : (id.startsWith(MEMBER_ID) ? node instanceof ObjectMemberTreeNode && id.substring(MEMBER_ID.length()).equals(((ObjectMemberTreeNode)node).getName()) : id.startsWith(NAME_ID) && id.substring(NAME_ID.length()).equals(node.toString())))));
                    return result;
                }
            };
        }
        return nodeMatcher;
    }
}

