/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.action.FuegoObjectAction;
import oracle.bpm.designer.action.InheritAction;
import oracle.bpm.designer.action.OpenCatalogNodeAction;
import oracle.bpm.designer.action.OpenCloseMemberAction;
import oracle.bpm.designer.catalog.tree.CatalogObjectNode;
import oracle.bpm.designer.catalog.tree.ObjectMethodMemberTreeNode;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.TypeCatalogException;
import oracle.bpm.type.TypeFinder;
import oracle.bpm.type.TypeUtils;
import oracle.bpm.ui.FuegoWorker;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.xobject.lib.ConstructionException;

public class OverrideComponentMethodAction
extends FuegoObjectAction {
    private MethodTypeDescription member;
    private CatalogObjectNode parentNode;

    public OverrideComponentMethodAction(ObjectMethodMemberTreeNode node) {
        super(DesignerMsg.OVERRIDE_METHOD);
        ObjectMethodMemberTreeNode currentNode;
        this.requires(MethodTypeDescription.class);
        for (currentNode = node; currentNode != null && !(currentNode instanceof CatalogObjectNode); currentNode = currentNode.getParent()) {
        }
        this.parentNode = (CatalogObjectNode)((Object)currentNode);
        this.member = node == null ? null : node.getMember();
    }

    @Override
    public boolean doIt() {
        if (this.parentNode != null) {
            MethodTypeDescription methodTD;
            final ObjectTypeDescription type = this.parentNode.getObject();
            if (type.findMember(this.member.getName(), TypeFinder.Scope.CURRENT) != null) {
                MessageDialog.showNotice((Msg)DesignerMsg.SELECTED_NAME_IS_IN_XOBJ_BASE);
                return false;
            }
            try {
                methodTD = (MethodTypeDescription)FuegoWorker.post((FuegoWorker.Task)new FuegoWorker.Task(){

                    public Object run() throws ConstructionException {
                        MethodTypeDescription overriden = InheritAction.overrideMember(OverrideComponentMethodAction.this.member);
                        if (!OverrideComponentMethodAction.this.member.isAbstract()) {
                            overriden.clearModifier(524288L);
                        }
                        type.addMember(overriden);
                        return overriden;
                    }
                });
            }
            catch (Exception e) {
                MessageDialog.showError((Throwable)e);
                return false;
            }
            OpenCatalogNodeAction oca = new OpenCatalogNodeAction();
            oca.runWithSelection(type);
            try {
                OverrideComponentMethodAction.getTypeRepository(type).update(type);
            }
            catch (TypeCatalogException e) {
                MessageDialog.showError((Throwable)e);
                return false;
            }
            OpenCloseMemberAction.openMember(methodTD);
            return true;
        }
        return false;
    }

    @Override
    protected void updateEnableStatus(Selection selection) {
        boolean enabled = false;
        if (this.member != null && !this.member.isFinal()) {
            ObjectTypeDescription otd = this.parentNode.getObject();
            enabled = true;
            for (MethodTypeDescription current = otd.getMember(this.member.getName(), 14); current != null; current = current.getNextMethod()) {
                if (!TypeUtils.sameSignature(current, this.member)) continue;
                enabled = false;
                break;
            }
        }
        this.setEnabled(enabled);
    }
}

