/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.StudioEditor;
import oracle.bpm.designer.StudioWorkbench;
import oracle.bpm.designer.action.OpenEditorAction;
import oracle.bpm.designer.catalog.bpmobjects.BPMObjectEditor;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.type.TypeRef;
import oracle.bpm.xobject.presentationmodel.XFormPresentationModel;

public class OpenObjectPresentationAction
extends OpenEditorAction {
    TypeRef object;
    XFormPresentationModel presentationModel;

    public OpenObjectPresentationAction(XFormPresentationModel presentationModel, XObjectTypeDescription object) {
        super(LibMsg.OPEN);
        this.requires(XFormPresentationModel.class);
        this.requires(FlowNode.class);
        this.presentationModel = presentationModel;
        this.object = object.getRef();
    }

    @Override
    public void run() {
        CatalogObject catalogObject;
        StudioWorkbench workbench = this.getWorkbench();
        StudioEditor studioEditor = workbench.findEditorByObject(catalogObject = CatalogObjectImpl.create((TypeRef)this.object));
        if (studioEditor == null) {
            studioEditor = workbench.openEditorForObject(catalogObject);
        }
        BPMObjectEditor bpmObjectEditor = (BPMObjectEditor)studioEditor;
        bpmObjectEditor.openPresentation(this.presentationModel);
        workbench.activateEditor(studioEditor);
    }
}

