/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.selection.DefaultSelection;
import oracle.bpm.ui.selection.Selection;

public class OpenObjectAction
extends DesignerAction {
    public OpenObjectAction() {
        super(UIMsg.OPEN);
        this.setShowOnDisabled(false);
        this.requires(Object.class);
        this.setSmallIcon(null);
    }

    public OpenObjectAction(Object object) {
        this();
        this.requires(object.getClass());
        this.setSelection(DefaultSelection.createSingle((Object)object));
    }

    @Override
    public boolean doIt() {
        Object object = this.getSelection().as(Object.class);
        if (object != null) {
            AbstractStudioWorkbench.getInstance().openEditorForObject(object);
            return true;
        }
        return false;
    }

    public void unDoIt() {
    }

    protected void updateEnableStatus(Selection s) {
        CatalogObject object = (CatalogObject)this.getSelection().as(CatalogObject.class);
        if (object != null && object.isModule()) {
            this.setEnabled(false);
        }
    }
}

