/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.correlation.CorrelationPropertyDialog;
import oracle.bpm.project.model.CorrelationProperty;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.msg.UIMsg;

public class OpenCorrelationPropertyAction
extends DesignerAction {
    public OpenCorrelationPropertyAction() {
        this.requires(CorrelationProperty.class);
        this.setMsg(UIMsg.EDIT);
    }

    @Override
    public boolean doIt() {
        CorrelationProperty correlationProperty = this.getCorrelationProperty();
        Project project = correlationProperty.getProject();
        CorrelationPropertyDialog dialog = new CorrelationPropertyDialog(Ui.getRoot(), project, correlationProperty);
        if (dialog.display()) {
            try {
                correlationProperty.delete();
                CorrelationProperty newCorrelationProperty = (CorrelationProperty)dialog.getObject();
                project.setProperty(newCorrelationProperty);
            }
            catch (ProjectException e) {
                MessageDialog.showError((Throwable)e);
            }
        }
        return dialog.userAccepted();
    }

    private CorrelationProperty getCorrelationProperty() {
        return (CorrelationProperty)this.getSelection().as(CorrelationProperty.class);
    }
}

