/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.command.Command;
import oracle.bpm.designer.ActionRunner;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.correlation.CorrelationKeyDialog;
import oracle.bpm.project.command.design.CopyCorrelationKeyCommand;
import oracle.bpm.project.model.CorrelationKey;
import oracle.bpm.project.model.processes.correlations.CorrelationKeyContainer;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.msg.UIMsg;

public class OpenCorrelationKeyAction
extends DesignerAction {
    public OpenCorrelationKeyAction() {
        this.requires(CorrelationKey.class);
        this.setMsg(UIMsg.EDIT);
    }

    @Override
    public boolean doIt() {
        CorrelationKey correlationKey = (CorrelationKey)this.getCorrelationKey().copy();
        CorrelationKeyContainer container = correlationKey.getParentObject();
        CorrelationKeyDialog dialog = new CorrelationKeyDialog(Ui.getRoot(), container, correlationKey);
        boolean result = dialog.display();
        if (result) {
            try {
                ActionRunner.getInstance().run((Command)new CopyCorrelationKeyCommand(correlationKey, this.getCorrelationKey()));
            }
            catch (Exception e) {
                MessageDialog.showError((Throwable)e);
            }
        }
        return result;
    }

    private CorrelationKey getCorrelationKey() {
        return (CorrelationKey)this.getSelection().as(CorrelationKey.class);
    }
}

