/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.command.Command;
import oracle.bpm.designer.ActionRunner;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.conversation.ConversationDialog;
import oracle.bpm.project.command.design.CopyConversationCommand;
import oracle.bpm.project.model.processes.conversation.Conversation;
import oracle.bpm.project.model.processes.conversation.ConversationContainer;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.msg.UIMsg;

public class OpenConversationAction
extends DesignerAction {
    public OpenConversationAction() {
        this.requires(Conversation.class);
        this.setMsg(UIMsg.EDIT);
    }

    @Override
    public boolean doIt() {
        Conversation conversation = (Conversation)this.getConversation().copy();
        ConversationContainer container = conversation.getParentObject();
        ConversationDialog dialog = new ConversationDialog(Ui.getRoot(), container, conversation);
        boolean result = dialog.display();
        if (result) {
            try {
                ActionRunner.getInstance().run((Command)new CopyConversationCommand(conversation, this.getConversation()));
            }
            catch (Exception e) {
                MessageDialog.showError((Throwable)e);
            }
        }
        return result;
    }

    private Conversation getConversation() {
        return (Conversation)this.getSelection().as(Conversation.class);
    }
}

