/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.StudioEditor;
import oracle.bpm.designer.catalog.bpmobjects.BPMObjectEditor;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.xobject.lib.XObjectTypeDescriptionHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenCloseMemberAction
extends DesignerAction {
    @NotNull
    private final CatalogObject parent;

    public OpenCloseMemberAction(@NotNull CatalogObject parent) {
        super(UIMsg.OPEN);
        this.requires(MethodTypeDescription.class);
        this.parent = parent;
    }

    public static void openMember(@NotNull MethodTypeDescription mtd) {
        OpenCloseMemberAction.openMember(mtd, -1);
    }

    public static void openMember(@NotNull MethodTypeDescription mtd, int line) {
        CatalogObject parent = CatalogObjectImpl.create((TypeRef)mtd.getParent());
        BPMObjectEditor editor = OpenCloseMemberAction.findOrCreateEditor(parent);
        editor.openMember(mtd, line);
    }

    public static void closeMember(MethodTypeDescription mtd) {
        CatalogObject parent = CatalogObjectImpl.create((TypeRef)mtd.getParent());
        BPMObjectEditor editor = OpenCloseMemberAction.findEditor(parent);
        if (editor != null) {
            editor.closeMember(mtd);
        }
    }

    public static boolean canOpenMethod(MethodTypeDescription method) {
        return XObjectTypeDescriptionHelper.isEditableMethod((MethodTypeDescription)method);
    }

    @Override
    public void run() {
        MethodTypeDescription mtd = (MethodTypeDescription)this.getSelection().as(MethodTypeDescription.class);
        if (this.getMsg() == UIMsg.OPEN) {
            this.innerOpenMember(mtd);
        } else {
            this.innerCloseMember(mtd);
        }
    }

    protected void updateEnableStatus(Selection selection) {
        BPMObjectEditor editor = OpenCloseMemberAction.findEditor(this.parent);
        if (editor != null) {
            MethodTypeDescription member = (MethodTypeDescription)selection.as(MethodTypeDescription.class);
            boolean isOpened = editor.isEditorOpenedFor(member);
            if (!isOpened) {
                this.setMsg(UIMsg.OPEN);
            } else {
                this.setMsg(UIMsg.CLOSE);
            }
        }
        super.updateEnableStatus(selection);
    }

    @NotNull
    private static BPMObjectEditor findOrCreateEditor(@NotNull CatalogObject parent) {
        BPMObjectEditor editor = OpenCloseMemberAction.findEditor(parent);
        if (editor == null) {
            editor = (BPMObjectEditor)AbstractStudioWorkbench.getInstance().openEditorForObject(parent);
        }
        return editor;
    }

    @Nullable
    private static BPMObjectEditor findEditor(@NotNull CatalogObject parent) {
        StudioEditor editor = AbstractStudioWorkbench.getInstance().findEditorByObject(parent);
        if (BPMObjectEditor.class.isInstance(editor)) {
            return (BPMObjectEditor)editor;
        }
        return null;
    }

    private void innerCloseMember(@NotNull MethodTypeDescription member) {
        BPMObjectEditor editor = OpenCloseMemberAction.findEditor(this.parent);
        if (editor != null) {
            editor.closeMember(member);
        }
    }

    private void innerOpenMember(@NotNull MethodTypeDescription member) {
        BPMObjectEditor editor = OpenCloseMemberAction.findOrCreateEditor(this.parent);
        editor.openMember(member, -1);
    }
}

