/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.collections.Sequence;
import oracle.bpm.command.Command;
import oracle.bpm.designer.BaseTransitionPropertiesDialog;
import oracle.bpm.designer.SequenceFlowPropertiesDialog;
import oracle.bpm.designer.action.StudioOperation;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.project.command.design.AddTransitionCommand;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.TransitionType;
import oracle.bpm.project.model.processes.activities.UserSelectsTransitionFeature;
import oracle.bpm.project.process.policies.SequenceFlowPolicies;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiContainer;

public class NewTransitionOperation
extends StudioOperation {
    TransitionType type;
    private final FlowNode from;
    private final FlowNode to;
    private SequenceFlow transition;

    public NewTransitionOperation(SequenceFlow transition) {
        this.transition = transition;
        this.from = transition.getSource();
        this.to = transition.getTarget();
        this.type = TransitionType.UNCONDITIONAL;
    }

    public NewTransitionOperation(FlowNode from, FlowNode to, TransitionType type) {
        this.from = from;
        this.to = to;
        this.type = type;
        this.transition = from.getParentObject().createSequenceFlow(from, to);
        if (type.isConditional()) {
            this.transition.toConditionalFlow();
        }
        this.transition.setSource(from);
        this.transition.setTarget(to);
    }

    @Override
    public boolean run() throws ProjectException {
        Sequence unconditionals = this.from.getOutgoingSequenceFlows();
        DesignerPreferences preferences = DesignerPreferences.getPreferences();
        boolean doShowProperties = preferences.showPropertiesAutomaticallyWhenAddingTransition();
        boolean isUnconditional = this.type != TransitionType.CONDITIONAL;
        boolean ignoreShowUnconditionals = preferences.ignoreShowPropertiesForUnconditionalTransitions();
        UserSelectsTransitionFeature userSelectsTransitionFeature = (UserSelectsTransitionFeature)this.from.getFeature(UserSelectsTransitionFeature.class);
        doShowProperties = doShowProperties && (!isUnconditional || !ignoreShowUnconditionals);
        boolean bl = doShowProperties = doShowProperties && (!unconditionals.isEmpty() || userSelectsTransitionFeature == null || userSelectsTransitionFeature.getValue() == false);
        if (doShowProperties) {
            BaseTransitionPropertiesDialog dialog = SequenceFlowPropertiesDialog.createDialog(this.transition);
            dialog.setVisible(true);
            if (!dialog.userAccepted()) {
                return false;
            }
        }
        try {
            SequenceFlowPolicies.checkSequenceFlow((FlowNode)this.from, (FlowNode)this.to, (boolean)this.type.isConditional());
        }
        catch (ProjectException e) {
            MessageDialog.showError((UiContainer)Ui.getRoot(), (Msg)DesignerMsg.TRANS_NOT_ALLOW, (Msg)e.getMsg());
            return false;
        }
        this.getRunner().run((Command)new AddTransitionCommand(this.transition));
        return false;
    }
}

