/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.command.Command;
import oracle.bpm.designer.ActionRunner;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.datadeclaration.DataDeclarationDialog;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.project.ProcessArgumentContainer;
import oracle.bpm.project.command.design.AddDataDeclarationCommand;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.msg.UIMsg;

public class NewProcessArgumentAction
extends DesignerAction {
    private static final String DEFAULT_NAME = "argument";

    public NewProcessArgumentAction() {
        this.requires(ProcessArgumentContainer.class);
        this.setMsg(UIMsg.NEW);
    }

    @Override
    public boolean doIt() {
        try {
            ProcessArgumentContainer nodeContainer = this.getNodeContainer();
            String name = NewProcessArgumentAction.getDefaultArgumentName(nodeContainer);
            DataDeclaration declaration = nodeContainer.createDeclaration(name, CatalogType.Default.getString());
            DataDeclarationDialog dialog = DataDeclarationDialog.createForArgument(Ui.getRoot(), declaration, nodeContainer.getLocalDeclarations(), false, true);
            dialog.setVisible(true);
            if (dialog.userAccepted()) {
                ActionRunner.getInstance().run((Command)new AddDataDeclarationCommand((DataDeclarationContainer)nodeContainer, declaration));
                return true;
            }
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ProjectException) {
                MessageDialog.showError((Msg)((ProjectException)e.getCause()).getMsg());
            }
            throw e;
        }
        catch (ProjectException e) {
            MessageDialog.showError((Msg)e.getMsg());
        }
        return false;
    }

    private static String getDefaultArgumentName(ProcessArgumentContainer nodeContainer) {
        int count = 1;
        String varName = DEFAULT_NAME;
        while (nodeContainer.findLocalDeclaration(DEFAULT_NAME + count) != null) {
            ++count;
        }
        return DEFAULT_NAME + count;
    }

    private ProcessArgumentContainer getNodeContainer() {
        return (ProcessArgumentContainer)this.getSelection().as(ProcessArgumentContainer.class);
    }
}

