/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.action.ModuleAction;
import oracle.bpm.designer.catalog.ModuleNameInputValidator;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.InputValidationException;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.Transactable;
import oracle.bpm.project.model.catalog.CatalogModule;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.ui.msg.ProjectUiMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.InputValidator;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.selection.DefaultSelection;
import oracle.bpm.ui.selection.Selection;

public class NewModuleAction
extends ModuleAction {
    private CatalogModule module;

    public NewModuleAction() {
        this((CatalogModule)null);
    }

    public NewModuleAction(CatalogModule parent) {
        super(DesignerMsg.MODULE);
        this.setExcludeDefault(true);
        this.setShowOnDisabled(false);
        if (parent != null) {
            this.setSelection(DefaultSelection.createSingle((Object)parent));
        }
    }

    @Override
    public void run() {
        this.newModule();
    }

    public CatalogModule getNewlyCreated() {
        return this.module;
    }

    @Override
    protected void updateEnableStatus(Selection selection) {
        CatalogModule description = (CatalogModule)this.getSelection().as(CatalogModule.class);
        if (description == null || description.isDefault()) {
            this.setEnabled(false);
        }
    }

    protected String getSuggestedName(CatalogModule type) {
        String prefix;
        int i = 1;
        boolean isValid = false;
        String suggestedName = prefix = this.getSuggestedPrefix();
        do {
            try {
                ModuleNameInputValidator.validateUnique(type.getObjectType(), suggestedName);
                isValid = true;
            }
            catch (InputValidationException e) {
                suggestedName = prefix + i;
                ++i;
            }
        } while (!isValid);
        return suggestedName;
    }

    protected String getSuggestedPrefix() {
        return DesignerMsg.NEW_MODULE.getString().replaceAll(" ", "_");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean newModule() {
        CatalogModule parent = (CatalogModule)this.getSelection().as(CatalogModule.class);
        String name = this.askForName(parent);
        Transactable txn = (Transactable)parent;
        if (name != null) {
            try {
                txn.beginTransaction();
                this.module = parent.newModule(name);
                parent.asMutable().addChild((ProjectObject)this.module);
                boolean bl = true;
                return bl;
            }
            catch (ProjectException e) {
                MessageDialog.showError((Throwable)e);
            }
            finally {
                txn.endTransaction();
            }
        }
        return false;
    }

    private String askForName(CatalogModule parent) {
        ModuleNameInputValidator validator = new ModuleNameInputValidator(parent.getObjectType());
        return MessageDialog.showInputModule((UiWindow)Ui.getRoot(), (Msg)ProjectUiMsg.CREATE((Msg)DesignerMsg.NEW_MODULE), (Msg)DesignerMsg.NEW_MODULE, (InputValidator)((Object)validator), (String)this.getSuggestedName(parent));
    }
}

