/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.navigator.ProjectNavigatorBuilder;
import oracle.bpm.project.model.FolderContainer;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.ui.msg.ProjectUiMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.selection.Selection;

public class NewModelContainerAction
extends DesignerAction {
    public NewModelContainerAction() {
        super(DesignerMsg.FOLDER);
        this.requires(FolderContainer.class);
        this.requires(Project.class);
    }

    public static FolderContainer selectContainer(Project project) {
        return new ProjectNavigatorBuilder((ProjectObject)project.getModelsRoot(), DesignerMsg.CHOOSE_TARGET_CONTAINER).include(FolderContainer.class).showRoot().selectSingle(FolderContainer.class);
    }

    @Override
    public void run() {
        this.newFolder();
    }

    private static String getNewName(Sequence<FolderContainer> childs) {
        String newName;
        boolean nameExists;
        int counter = 1;
        do {
            nameExists = false;
            newName = "NewFolder" + counter++;
            for (FolderContainer child : childs) {
                if (!child.getId().equals(newName)) continue;
                nameExists = true;
            }
        } while (nameExists);
        return newName;
    }

    private FolderContainer resolveContainer() {
        Project project;
        FolderContainer result = null;
        Selection currentSelection = this.getSelection();
        if (currentSelection != null && (result = (FolderContainer)currentSelection.as(FolderContainer.class)) == null && (project = (Project)currentSelection.as(Project.class)) != null) {
            result = NewModelContainerAction.selectContainer(project);
        }
        return result;
    }

    private void newFolder() {
        FolderContainer container = this.resolveContainer();
        if (container == null) {
            return;
        }
        try {
            String newContainerName = this.getNewContainerName(container);
            if (newContainerName == null) {
                return;
            }
            FolderContainer newContainer = container.createContainer(newContainerName);
            container.addChild((ProjectObject)newContainer);
        }
        catch (ProjectException e) {
            MessageDialog.showError((Msg)e.getMsg());
        }
    }

    private String getNewContainerName(FolderContainer container) throws ProjectException {
        String newName;
        Sequence children = container.getChildrenByType(FolderContainer.class);
        String result = newName = NewModelContainerAction.getNewName(children);
        boolean wrongName = true;
        while ((result = MessageDialog.showInputDialog((UiWindow)Ui.getRoot(), (Msg)ProjectUiMsg.CREATE((Msg)DesignerMsg.FOLDER), (Msg)DesignerMsg.DIRECTORY_NAME, null, (String)result, (boolean)true)) != null) {
            if ("".equals(result)) {
                MessageDialog.showError((UiContainer)Ui.getRoot(), (Msg)DesignerMsg.FOLDER_NAME_CANNOT_BE_EMPTY);
                result = newName;
            } else {
                boolean duplicated = false;
                for (FolderContainer child : children) {
                    if (!child.getId().equals(result)) continue;
                    duplicated = true;
                    break;
                }
                if (duplicated) {
                    throw new ProjectException((ProjectObject)container, DesignerMsg.PROJECT_DIR_ALREADY_EXISTS(result));
                }
                wrongName = false;
            }
            if (wrongName) continue;
        }
        return result;
    }
}

