/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.data.BusinessVariableType;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.variables.BusinessIndicatorDialogs;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.VirtualContainer;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.DataObject;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.project.virtual.VirtualBusinessIndicatorsContainer;
import oracle.bpm.project.virtual.VirtualCorrelationPropertiesContainer;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.action.BaseAction;

public class NewMeasureBIAction
extends BaseAction {
    private DataObject measureBI;
    private NodeContainer nodeContainer;
    public static final String DEFAULT_MEASURE_NAME = "measure";
    private static final BusinessVariableType MEASURE_TYPE = BusinessVariableType.MEASURE;

    public NewMeasureBIAction() {
        super(DesignerMsg.MEASURE);
        this.requires(VirtualBusinessIndicatorsContainer.class);
        this.requires(VirtualCorrelationPropertiesContainer.class);
        this.requires(Void.class);
    }

    public NewMeasureBIAction(NodeContainer nodeContainer) {
        this();
        this.nodeContainer = nodeContainer;
    }

    public void run() {
        this.newMeasureBI(this.getNodeContainer());
    }

    public DataObject getMeasureBI() {
        return this.measureBI;
    }

    private void newMeasureBI(NodeContainer nodeContainer) {
        String name = ModelUtils.getDefaultDataObjectName((String)DEFAULT_MEASURE_NAME, (NodeContainer)nodeContainer);
        try {
            ProjectDataObject newDataObject = (ProjectDataObject)nodeContainer.createDeclaration(name, CatalogType.Default.getInt());
            newDataObject.setBusinessVariableType(MEASURE_TYPE);
            if (BusinessIndicatorDialogs.showForCreation(Ui.getRoot(), newDataObject, MEASURE_TYPE)) {
                this.measureBI = newDataObject;
            }
        }
        catch (ProjectException e) {
            MessageDialog.showError((Msg)e.getMsg());
        }
    }

    private NodeContainer getNodeContainer() {
        return this.nodeContainer != null ? this.nodeContainer : this.getNodeContainerFromSelection();
    }

    private NodeContainer getNodeContainerFromSelection() {
        return this.getSelection().as(NodeContainer.class) != null ? (NodeContainer)this.getSelection().as(NodeContainer.class) : (NodeContainer)((VirtualContainer)this.getSelection().as(VirtualContainer.class)).getRealParent();
    }
}

