/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.action.FuegoObjectAction;
import oracle.bpm.designer.action.GroupNameInputValidator;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.TypeCatalogException;
import oracle.bpm.ui.InputValidator;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.xobject.XObjectFactory;
import oracle.bpm.xobject.lib.ConstructionException;
import oracle.bpm.xobject.lib.XObjectTypeDescriptionHelper;

public class NewGroupAction
extends FuegoObjectAction {
    public NewGroupAction() {
        super(DesignerMsg.ADD_GROUP);
        this.setShowOnDisabled(false);
    }

    @Override
    public void run() {
        this.newGroup();
    }

    @Override
    protected void updateEnableStatus(Selection selection) {
        CatalogObject catalogObject = (CatalogObject)selection.as(CatalogObject.class);
        ObjectTypeDescription objectType = catalogObject.getObjectType();
        this.setEnabled(this.isEditable(catalogObject) && !objectType.isInnerType());
    }

    private boolean newGroup() {
        CatalogObject catalogObject = (CatalogObject)this.getSelection().as(CatalogObject.class);
        ObjectTypeDescription otd = catalogObject.getObjectType();
        String name = MessageDialog.showInput((UiWindow)Ui.getRoot(), (Msg)DesignerMsg.ADD_GROUP, (Msg)DesignerMsg.GROUP_NAME, (String)this.suggestName(otd), (InputValidator)new GroupNameInputValidator(otd));
        if (name == null) {
            return false;
        }
        ObjectTypeDescription groupType = XObjectFactory.addGroupElement(otd, name);
        try {
            XObjectTypeDescriptionHelper.addGroupAttribute((ObjectTypeDescription)otd, (String)name, (ObjectTypeDescription)groupType);
        }
        catch (ConstructionException e) {
            MessageDialog.showError((Throwable)e);
            return false;
        }
        try {
            MutableComponentCatalog componentCatalog = NewGroupAction.getTypeRepository(otd);
            componentCatalog.add(groupType);
            componentCatalog.update(otd);
        }
        catch (TypeCatalogException e) {
            MessageDialog.showError((Throwable)e);
            return false;
        }
        return true;
    }

    private String suggestName(ObjectTypeDescription otd) {
        String name;
        int counter = 1;
        while (!XObjectTypeDescriptionHelper.isValidAttName((ObjectTypeDescription)otd, (String)(name = "group" + counter++))) {
        }
        return name;
    }
}

