/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.ObjectContainerDialog;
import oracle.bpm.designer.action.ModuleAction;
import oracle.bpm.designer.action.OpenObjectAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.BpmObject;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogModule;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.ErrorObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.ui.msg.ProjectUiMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiWindow;

public class NewExceptionAction
extends ModuleAction {
    private CatalogObject parent;

    public NewExceptionAction() {
        this((CatalogModule)null);
    }

    public NewExceptionAction(CatalogModule parent) {
        super(DesignerMsg.NEW_BUSINESS_EXCEPTION);
        this.parent = parent;
        this.setExcludeDefault(true);
        this.setExcludeRoot(true);
        this.setShowOnDisabled(false);
    }

    public static ErrorObject createException(UiWindow window, CatalogObject catalogObject) throws ProjectException {
        ObjectContainerDialog dialog = new ObjectContainerDialog(window, ProjectUiMsg.CREATE((Msg)DesignerMsg.NEW_BUSINESS_EXCEPTION), DesignerMsg.EXCEPTION, DesignerMsg.BUSINESS_EXCEPTION_PREFIX.toString(), catalogObject, catalogObject.getProject(), false);
        dialog.setVisible(true);
        ErrorObject result = null;
        if (dialog.userAccepted()) {
            CatalogModule parent = dialog.getParentModule();
            BpmObject newType = parent.newException(dialog.getObjectName());
            CatalogMember member = newType.asBpmObject().createAttribute("errorInfo", CatalogType.Default.getString());
            newType.addChild((ProjectObject)member);
            parent.asMutable().addChild((ProjectObject)newType);
            result = (ErrorObject)newType;
        }
        return result;
    }

    @Override
    public boolean doIt() {
        try {
            return this.newException();
        }
        catch (ProjectException e) {
            return false;
        }
    }

    public void unDoIt() {
    }

    private boolean newException() throws ProjectException {
        ErrorObject errorObject = NewExceptionAction.createException(Ui.getRoot(), this.parent);
        if (errorObject != null) {
            new OpenObjectAction(errorObject).run();
            return true;
        }
        return false;
    }
}

