/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.data.BusinessVariableType;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.variables.BusinessIndicatorDialogs;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.VirtualContainer;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.DataObject;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.project.virtual.VirtualBusinessIndicatorsContainer;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.action.BaseAction;

public class NewDimensionBIAction
extends BaseAction {
    private DataObject dimensionBI;
    private NodeContainer nodeContainer;
    public static final String DEFAULT_DIMENSION_NAME = "dimension";
    private static final BusinessVariableType DIMENSION_TYPE = BusinessVariableType.DIMENSION;

    public NewDimensionBIAction() {
        super(DesignerMsg.DIMENSION);
        this.requires(VirtualBusinessIndicatorsContainer.class);
        this.requires(Void.class);
    }

    public NewDimensionBIAction(NodeContainer nodeContainer) {
        this();
        this.nodeContainer = nodeContainer;
    }

    public void run() {
        NodeContainer nodeContainer = this.getNodeContainer();
        String name = ModelUtils.getDefaultDataObjectName((String)DEFAULT_DIMENSION_NAME, (NodeContainer)nodeContainer);
        try {
            ProjectDataObject newDataObject = (ProjectDataObject)nodeContainer.createDeclaration(name, CatalogType.Default.getInt());
            newDataObject.setBusinessVariableType(DIMENSION_TYPE);
            if (BusinessIndicatorDialogs.showForCreation(Ui.getRoot(), newDataObject, DIMENSION_TYPE)) {
                this.dimensionBI = newDataObject;
            }
        }
        catch (ProjectException e) {
            MessageDialog.showError((Msg)e.getMsg());
        }
    }

    public DataObject getDimensionBI() {
        return this.dimensionBI;
    }

    private NodeContainer getNodeContainer() {
        return this.nodeContainer != null ? this.nodeContainer : this.getNodeContainerFromSelection();
    }

    private NodeContainer getNodeContainerFromSelection() {
        return this.getSelection().as(NodeContainer.class) != null ? (NodeContainer)this.getSelection().as(NodeContainer.class) : (NodeContainer)((VirtualContainer)this.getSelection().as(VirtualContainer.class)).getRealParent();
    }
}

