/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.data.BusinessVariableType;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.variables.BusinessIndicatorDialogs;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.VirtualContainer;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.DataObject;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.project.virtual.VirtualBusinessIndicatorsContainer;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.action.BaseAction;

public class NewCounterBIAction
extends BaseAction {
    private ProjectDataObject counterBI;
    private NodeContainer nodeContainer;
    public static final String DEFAULT_COUNTER_NAME = "counter";
    private static final BusinessVariableType COUNTER_TYPE = BusinessVariableType.COUNTER;

    public NewCounterBIAction() {
        super(DesignerMsg.COUNTER);
        this.requires(VirtualBusinessIndicatorsContainer.class);
        this.requires(Void.class);
    }

    public NewCounterBIAction(NodeContainer nodeContainer) {
        this();
        this.nodeContainer = nodeContainer;
    }

    public void run() {
        this.newCounterBI(this.getNodeContainer());
    }

    public DataObject getCounterBI() {
        return this.counterBI;
    }

    private void newCounterBI(NodeContainer nodeContainer) {
        String name = ModelUtils.getDefaultDataObjectName((String)DEFAULT_COUNTER_NAME, (NodeContainer)nodeContainer);
        try {
            ProjectDataObject newDataObject = (ProjectDataObject)nodeContainer.createDeclaration(name, CatalogType.Default.getInt());
            newDataObject.setBusinessVariableType(COUNTER_TYPE);
            if (BusinessIndicatorDialogs.showForCreation(Ui.getRoot(), newDataObject, COUNTER_TYPE)) {
                this.counterBI = newDataObject;
            }
        }
        catch (ProjectException e) {
            MessageDialog.showError((Msg)e.getMsg());
        }
    }

    private NodeContainer getNodeContainer() {
        return this.nodeContainer != null ? this.nodeContainer : this.getNodeContainerFromSelection();
    }

    private NodeContainer getNodeContainerFromSelection() {
        return this.getSelection().as(NodeContainer.class) != null ? (NodeContainer)this.getSelection().as(NodeContainer.class) : (NodeContainer)((VirtualContainer)this.getSelection().as(VirtualContainer.class)).getRealParent();
    }
}

