/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.correlation.CorrelationPropertyDialog;
import oracle.bpm.project.model.CorrelationProperty;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.virtual.VirtualCorrelationPropertiesContainer;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.msg.UIMsg;
import org.jetbrains.annotations.NotNull;

public class NewCorrelationPropertyAction
extends DesignerAction {
    private Project project;

    public NewCorrelationPropertyAction() {
        super(UIMsg.NEW);
        this.requires(VirtualCorrelationPropertiesContainer.class);
        this.requires(Void.class);
    }

    public NewCorrelationPropertyAction(@NotNull Project project) {
        this();
        this.project = project;
    }

    @Override
    public void run() {
        Project project = this.getProject();
        CorrelationPropertyDialog dialog = new CorrelationPropertyDialog(Ui.getRoot(), project, null);
        if (dialog.display()) {
            try {
                CorrelationProperty newCorrelationProperty = (CorrelationProperty)dialog.getObject();
                project.setProperty(newCorrelationProperty);
            }
            catch (ProjectException e) {
                MessageDialog.showError((Throwable)e);
            }
        }
    }

    private Project getProject() {
        return this.project != null ? this.project : (Project)((VirtualCorrelationPropertiesContainer)this.getSelection().as(VirtualCorrelationPropertiesContainer.class)).getRealParent();
    }
}

