/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.command.Command;
import oracle.bpm.designer.ActionRunner;
import oracle.bpm.designer.correlation.CorrelationKeyDialog;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.project.command.design.AddCorrelationKeyCommand;
import oracle.bpm.project.model.CorrelationKey;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.correlations.CorrelationKeyContainer;
import oracle.bpm.project.virtual.VirtualCorrelationKeysContainer;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.msg.UIMsg;
import org.jetbrains.annotations.NotNull;

public class NewCorrelationKeyAction
extends BaseAction {
    private CorrelationKeyContainer container;

    public NewCorrelationKeyAction() {
        super(UIMsg.NEW);
        this.requires(VirtualCorrelationKeysContainer.class);
        this.requires(Void.class);
    }

    public NewCorrelationKeyAction(@NotNull CorrelationKeyContainer container) {
        this();
        this.container = container;
    }

    public void run() {
        CorrelationKeyContainer container = this.getContainer();
        CorrelationKeyDialog dialog = new CorrelationKeyDialog(Ui.getRoot(), container, null);
        if (dialog.display()) {
            try {
                CorrelationKey newCorrelationKey = (CorrelationKey)dialog.getObject();
                ActionRunner.getInstance().run((Command)new AddCorrelationKeyCommand(container, newCorrelationKey));
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof ProjectException) {
                    MessageDialog.showError((Msg)((ProjectException)e.getCause()).getMsg());
                }
                throw e;
            }
        }
    }

    private CorrelationKeyContainer getContainer() {
        return this.container != null ? this.container : (CorrelationKeyContainer)((VirtualCorrelationKeysContainer)this.getSelection().as(VirtualCorrelationKeysContainer.class)).getRealParent();
    }
}

