/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.command.Command;
import oracle.bpm.designer.ActionRunner;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.conversation.ConversationDialog;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.project.command.design.AddConversationCommand;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.conversation.Conversation;
import oracle.bpm.project.model.processes.conversation.ConversationContainer;
import oracle.bpm.project.virtual.VirtualConversationsContainer;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.msg.UIMsg;
import org.jetbrains.annotations.NotNull;

public class NewConversationAction
extends DesignerAction {
    private ConversationContainer container;

    public NewConversationAction() {
        super(UIMsg.NEW);
        this.requires(VirtualConversationsContainer.class);
        this.requires(Void.class);
    }

    public NewConversationAction(@NotNull ConversationContainer container) {
        this();
        this.container = container;
    }

    @Override
    public void run() {
        ConversationContainer conversationContainer = this.getConversationContainer();
        ConversationDialog dialog = new ConversationDialog(Ui.getRoot(), conversationContainer, null);
        if (dialog.display()) {
            try {
                Conversation newConversation = (Conversation)dialog.getObject();
                ActionRunner.getInstance().run((Command)new AddConversationCommand(conversationContainer, newConversation));
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof ProjectException) {
                    MessageDialog.showError((Msg)((ProjectException)e.getCause()).getMsg());
                }
                throw e;
            }
        }
    }

    private ConversationContainer getConversationContainer() {
        return this.container != null ? this.container : (ConversationContainer)((VirtualConversationsContainer)this.getSelection().as(VirtualConversationsContainer.class)).getRealParent();
    }
}

