/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.data.BusinessVariableType;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.variables.BusinessIndicatorDialogs;
import oracle.bpm.project.ProcessContent;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.VirtualContainer;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.DataObject;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.project.virtual.VirtualAttributeBIContainer;
import oracle.bpm.project.virtual.VirtualBusinessIndicatorsContainer;
import oracle.bpm.project.virtual.VirtualCounterBIContainer;
import oracle.bpm.project.virtual.VirtualDimensionBIContainer;
import oracle.bpm.project.virtual.VirtualMeasureBIContainer;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.msg.UIMsg;
import org.jetbrains.annotations.NotNull;

public class NewBusinessIndicatorAction
extends DesignerAction {
    private DataObject dataObject;
    private BusinessVariableType type;
    private static final BusinessVariableType DEFAULT_TYPE = BusinessVariableType.DIMENSION;

    private NewBusinessIndicatorAction(@NotNull BusinessVariableType type) {
        this.requires(VirtualBusinessIndicatorsContainer.class);
        this.requires(ProcessContent.class);
        this.requires(VirtualDimensionBIContainer.class);
        this.requires(VirtualMeasureBIContainer.class);
        this.requires(VirtualCounterBIContainer.class);
        this.requires(VirtualAttributeBIContainer.class);
        this.type = type;
        this.setMsg(UIMsg.NEW);
    }

    public static final NewBusinessIndicatorAction createForMeasurement() {
        return new NewBusinessIndicatorAction(BusinessVariableType.MEASURE);
    }

    public static final NewBusinessIndicatorAction createForCounter() {
        return new NewBusinessIndicatorAction(BusinessVariableType.COUNTER);
    }

    public static NewBusinessIndicatorAction createForAttribute() {
        return new NewBusinessIndicatorAction(BusinessVariableType.ATTRIBUTE);
    }

    public static NewBusinessIndicatorAction createForDimension() {
        return new NewBusinessIndicatorAction(BusinessVariableType.DIMENSION);
    }

    @Override
    public boolean doIt() {
        NodeContainer nodeContainer = this.getNodeContainer();
        String proposedName = this.type.isCounter() ? "counter" : (this.type.isDimension() ? "dimension" : (this.type.isAttribute() ? "attribute" : "measure"));
        String name = ModelUtils.getDefaultDataObjectName((String)proposedName, (NodeContainer)nodeContainer);
        try {
            ProjectDataObject newDataObject = (ProjectDataObject)nodeContainer.createDeclaration(name, CatalogType.Default.getInt());
            newDataObject.setBusinessVariableType(this.type);
            if (BusinessIndicatorDialogs.showForCreation(Ui.getRoot(), newDataObject, this.type)) {
                this.dataObject = newDataObject;
                return true;
            }
        }
        catch (ProjectException e) {
            MessageDialog.showError((Msg)e.getMsg());
        }
        return false;
    }

    public DataObject getDataObject() {
        return this.dataObject;
    }

    private NodeContainer getNodeContainer() {
        return this.getSelection().as(NodeContainer.class) != null ? (NodeContainer)this.getSelection().as(NodeContainer.class) : (NodeContainer)((VirtualContainer)this.getSelection().as(VirtualContainer.class)).getRealParent();
    }
}

